/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.IntegerType;

public class IntegerTypeMutatorProvider
implements FhirTypeMutatorProvider<IntegerType> {
    private final List<FuzzingMutator<IntegerType>> mutators = IntegerTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<IntegerType>> createMutators() {
        LinkedList<FuzzingMutator<IntegerType>> mutators = new LinkedList<FuzzingMutator<IntegerType>>();
        mutators.add((ctx, it) -> ctx.fuzzIdElement(IntegerType.class, it));
        mutators.add((ctx, it) -> ctx.fuzzChildTypes(IntegerType.class, IntegerTypeMutatorProvider.ensureNotNull(ctx.randomness(), it).getExtension()));
        mutators.add((ctx, it) -> {
            it = IntegerTypeMutatorProvider.ensureNotNull(ctx.randomness(), it);
            it.setValue((Object)ctx.randomness().source().nextInt(Integer.MIN_VALUE, Integer.MAX_VALUE));
            return FuzzingLogEntry.operation("Fuzz IntegerType");
        });
        return mutators;
    }

    private static IntegerType ensureNotNull(Randomness randomness, IntegerType it) {
        if (it == null) {
            it = randomness.fhir().createType(IntegerType.class);
        }
        return it;
    }

    @Override
    @Generated
    public List<FuzzingMutator<IntegerType>> getMutators() {
        return this.mutators;
    }
}

