/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.InstantType;

public class InstantTypeMutatorProvider
implements FhirTypeMutatorProvider<InstantType> {
    private final List<FuzzingMutator<InstantType>> mutators = InstantTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<InstantType>> createMutators() {
        LinkedList<FuzzingMutator<InstantType>> mutators = new LinkedList<FuzzingMutator<InstantType>>();
        mutators.add((ctx, itt) -> ctx.fuzzIdElement(InstantType.class, itt));
        mutators.add((ctx, itt) -> ctx.fuzzChildTypes(InstantType.class, InstantTypeMutatorProvider.ensureNotNull(ctx.randomness(), itt).getExtension()));
        mutators.add((ctx, itt) -> {
            itt = InstantTypeMutatorProvider.ensureNotNull(ctx.randomness(), itt);
            Date date = ctx.randomness().date();
            TemporalPrecisionEnum precision = ctx.randomness().chooseRandomFromEnum(TemporalPrecisionEnum.class);
            itt.setValue(date, precision);
            return FuzzingLogEntry.operation(MessageFormat.format("Change Date of InstantType to {0}", itt.getValueAsString()));
        });
        return mutators;
    }

    private static InstantType ensureNotNull(Randomness randomness, InstantType itt) {
        if (itt == null) {
            TemporalPrecisionEnum precision = randomness.chooseRandomFromEnum(TemporalPrecisionEnum.class);
            itt = randomness.fhir().createType(InstantType.class);
            itt.setValue(randomness.date(), precision);
        }
        return itt;
    }

    @Override
    @Generated
    public List<FuzzingMutator<InstantType>> getMutators() {
        return this.mutators;
    }
}

