/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveStringTypes;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeFuzzingResponse;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Identifier;

public class IdentifierTypeMutatorProvider
implements FhirTypeMutatorProvider<Identifier> {
    private final List<FuzzingMutator<Identifier>> mutators = IdentifierTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<Identifier>> createMutators() {
        LinkedList<FuzzingMutator<Identifier>> mutators = new LinkedList<FuzzingMutator<Identifier>>();
        mutators.add((ctx, identifier) -> ctx.fuzzIdElement(Identifier.class, identifier));
        mutators.add((ctx, identifier) -> ctx.fuzzChildTypes(Identifier.class, IdentifierTypeMutatorProvider.ensureNotNull(ctx.randomness(), identifier).getExtension()));
        mutators.add((ctx, identifier) -> {
            identifier = IdentifierTypeMutatorProvider.ensureNotNull(ctx.randomness(), identifier);
            String system = identifier.getSystem();
            String message = MessageFormat.format("Fuzz IdentifierSystem: {0}", system);
            PrimitiveTypeFuzzingResponse<String> response = ctx.fuzzPrimitiveType(message, PrimitiveStringTypes.URI, system);
            identifier.setSystem(response.getFuzzedValue());
            return response.getLogEntry();
        });
        mutators.add((ctx, identifier) -> {
            identifier = IdentifierTypeMutatorProvider.ensureNotNull(ctx.randomness(), identifier);
            String oids = identifier.getSystem();
            String version = ctx.randomness().version();
            String fids = MessageFormat.format("{0}|{1}", identifier.getSystem(), version);
            identifier.setSystem(fids);
            return FuzzingLogEntry.operation(MessageFormat.format("Append random Version to IdentifierSystem: {0} -> {1}", oids, fids));
        });
        mutators.add((ctx, identifier) -> {
            identifier = IdentifierTypeMutatorProvider.ensureNotNull(ctx.randomness(), identifier);
            String oidv = identifier.getValue();
            String fidv = oidv != null && ctx.randomness().source().nextBoolean() ? MessageFormat.format("{0}{1}", Character.valueOf(oidv.charAt(0)), oidv) : (oidv != null ? MessageFormat.format("{0}{1}", oidv, Character.valueOf(oidv.charAt(oidv.length() - 1))) : ctx.randomness().regexify("[0-9]{5,30}"));
            identifier.setValue(fidv);
            return FuzzingLogEntry.operation(MessageFormat.format("Change Identifier Value: {0} -> {1}", oidv, fidv));
        });
        mutators.add((ctx, identifier) -> {
            identifier = IdentifierTypeMutatorProvider.ensureNotNull(ctx.randomness(), identifier);
            String oidv = identifier.getValue();
            identifier.setValue(null);
            return FuzzingLogEntry.operation(MessageFormat.format("Remove Value from Identifier: {0}", oidv));
        });
        mutators.add((ctx, identifier) -> {
            identifier = IdentifierTypeMutatorProvider.ensureNotNull(ctx.randomness(), identifier);
            String oidv = identifier.getValue();
            String oids = identifier.getSystem();
            identifier.setValue(oids);
            identifier.setSystem(oidv);
            return FuzzingLogEntry.operation(MessageFormat.format("Swap Identifier Value and System: {0} <-> {1}", oidv, oids));
        });
        mutators.add((ctx, identifier) -> {
            identifier = IdentifierTypeMutatorProvider.ensureNotNull(ctx.randomness(), identifier);
            String oids = identifier.getSystem();
            identifier.setSystem(null);
            return FuzzingLogEntry.operation(MessageFormat.format("Remove System from Identifier: {0}", oids));
        });
        return mutators;
    }

    private static Identifier ensureNotNull(Randomness randomness, Identifier identifier) {
        if (identifier == null) {
            identifier = randomness.fhir().createType(Identifier.class);
        }
        return identifier;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Identifier>> getMutators() {
        return this.mutators;
    }
}

