/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.ResourceType;

public class IdTypeMutatorProvider
implements FhirTypeMutatorProvider<IdType> {
    private final List<FuzzingMutator<IdType>> mutators = IdTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<IdType>> createMutators() {
        LinkedList<FuzzingMutator<IdType>> mutators = new LinkedList<FuzzingMutator<IdType>>();
        mutators.add((ctx, idt) -> ctx.fuzzIdElement(IdType.class, idt));
        mutators.add((ctx, idt) -> ctx.fuzzChildTypes(IdType.class, IdTypeMutatorProvider.ensureNotNull(ctx.randomness(), idt).getExtension()));
        mutators.add((ctx, idt) -> {
            String fidv;
            String[] oidvTokens;
            idt = IdTypeMutatorProvider.ensureNotNull(ctx.randomness(), idt);
            String oidv = idt.getValue();
            String[] stringArray = oidvTokens = oidv != null ? oidv.split("/") : ctx.randomness().fhir().fhirResourceId().split("/");
            if (oidvTokens.length == 2) {
                if (ctx.randomness().source().nextBoolean()) {
                    fidv = MessageFormat.format("{0}/{1}", oidvTokens[0], ctx.randomness().uuid());
                } else {
                    ResourceType rr = ctx.randomness().chooseRandomFromEnum(ResourceType.class);
                    fidv = MessageFormat.format("{0}/{1}", rr.toString(), oidvTokens[1]);
                }
            } else {
                fidv = oidv.startsWith("http") ? oidv.replace(oidvTokens[oidvTokens.length - 1], ctx.randomness().uuid()) : UUID.randomUUID().toString();
            }
            idt.setValue(fidv);
            return FuzzingLogEntry.operation(MessageFormat.format("Replace IdElement value: {0} -> {1}", oidv, fidv));
        });
        return mutators;
    }

    private static IdType ensureNotNull(Randomness randomness, IdType idType) {
        if (idType == null) {
            idType = randomness.fhir().createType(IdType.class);
        }
        return idType;
    }

    @Override
    @Generated
    public List<FuzzingMutator<IdType>> getMutators() {
        return this.mutators;
    }
}

