/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.HumanName;

public class HumanNameTypeMutatorProvider
implements FhirTypeMutatorProvider<HumanName> {
    private final List<FuzzingMutator<HumanName>> mutators = HumanNameTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<HumanName>> createMutators() {
        LinkedList<FuzzingMutator<HumanName>> mutators = new LinkedList<FuzzingMutator<HumanName>>();
        mutators.add((ctx, humanname) -> ctx.fuzzIdElement(HumanName.class, humanname));
        mutators.add((ctx, humanname) -> ctx.fuzzChildTypes(HumanName.class, HumanNameTypeMutatorProvider.ensureNotNull(ctx.randomness(), humanname).getExtension()));
        mutators.add((ctx, humanname) -> ctx.fuzzChild(HumanName.class, HumanNameTypeMutatorProvider.ensureNotNull(ctx.randomness(), humanname).getFamilyElement()));
        mutators.add((ctx, humanname) -> ctx.fuzzChildTypes(HumanName.class, HumanNameTypeMutatorProvider.ensureNotNull(ctx.randomness(), humanname).getGiven()));
        mutators.add((ctx, humanname) -> ctx.fuzzChildTypes(HumanName.class, HumanNameTypeMutatorProvider.ensureNotNull(ctx.randomness(), humanname).getPrefix()));
        mutators.add((ctx, humanname) -> ctx.fuzzChildTypes(HumanName.class, HumanNameTypeMutatorProvider.ensureNotNull(ctx.randomness(), humanname).getSuffix()));
        mutators.add((ctx, humanname) -> ctx.fuzzChild(HumanName.class, HumanNameTypeMutatorProvider.ensureNotNull(ctx.randomness(), humanname).getPeriod()));
        return mutators;
    }

    private static HumanName ensureNotNull(Randomness randomness, HumanName humanName) {
        if (humanName == null) {
            humanName = randomness.fhir().createType(HumanName.class);
        }
        return humanName;
    }

    @Override
    @Generated
    public List<FuzzingMutator<HumanName>> getMutators() {
        return this.mutators;
    }
}

