/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;

public class ExtensionTypeMutatorProvider
implements FhirTypeMutatorProvider<Extension> {
    private final List<FuzzingMutator<Extension>> mutators = ExtensionTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<Extension>> createMutators() {
        LinkedList<FuzzingMutator<Extension>> mutators = new LinkedList<FuzzingMutator<Extension>>();
        mutators.add((ctx, extension) -> ctx.fuzzIdElement(Extension.class, extension));
        mutators.add((ctx, extension) -> ctx.fuzzChild(Extension.class, ExtensionTypeMutatorProvider.ensureNotNull(ctx.randomness(), extension).getUrlElement()));
        mutators.add((ctx, extension) -> {
            extension = ExtensionTypeMutatorProvider.ensureNotNull(ctx.randomness(), extension);
            String id = extension.getId();
            return ctx.randomness().chooseRandomly(extension.getExtension()).map(ext -> ctx.fuzzChild(Extension.class, ext)).orElseGet(() -> FuzzingLogEntry.noop(MessageFormat.format("Extension with ID ''{0}'' does not have any child extensions", id)));
        });
        mutators.add((ctx, extension) -> {
            extension = ExtensionTypeMutatorProvider.ensureNotNull(ctx.randomness(), extension);
            List children = extension.getExtension();
            if (!children.isEmpty()) {
                ctx.randomness().childResourceDice().chooseRandomElements(children).forEach(children::remove);
                return FuzzingLogEntry.operation(MessageFormat.format("Remove randomly child extensions in extension {0}", extension.getId()));
            }
            if (!extension.hasValue()) {
                int amount = ctx.randomness().source().nextInt(1, 10);
                for (int idx = 0; idx < amount; ++idx) {
                    Type type = ctx.randomness().fhir().createType();
                    type.setIdBase(ctx.randomness().uuid());
                    extension.addExtension(ctx.randomness().url(idx), type);
                }
                return FuzzingLogEntry.operation(MessageFormat.format("Add randomly {0} child extensions to extension {1}", amount, extension.getId()));
            }
            return ctx.fuzzChild(extension.getClass(), extension.getValue());
        });
        return mutators;
    }

    private static Extension ensureNotNull(Randomness randomness, Extension extension) {
        if (extension == null) {
            extension = randomness.fhir().createType(Extension.class);
        }
        if (extension.getValue() == null) {
            extension.setValue((Type)new StringType(randomness.regexify("[A-Za-z0-9._%$+-]{1,10}")));
        }
        if (extension.getUrl() == null) {
            extension.setUrl(randomness.url());
        }
        List children = extension.getExtension();
        extension.setExtension(new ArrayList(children));
        return extension;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Extension>> getMutators() {
        return this.mutators;
    }
}

