/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Expression;

public class ExpressionMutatorProvider
implements FhirTypeMutatorProvider<Expression> {
    private final List<FuzzingMutator<Expression>> mutators = ExpressionMutatorProvider.createMutators();

    private static List<FuzzingMutator<Expression>> createMutators() {
        LinkedList<FuzzingMutator<Expression>> mutators = new LinkedList<FuzzingMutator<Expression>>();
        mutators.add((ctx, expression) -> ctx.fuzzIdElement(Expression.class, expression));
        mutators.add((ctx, expression) -> ctx.fuzzChildTypes(Expression.class, ExpressionMutatorProvider.ensureNotNull(ctx.randomness(), expression).getExtension()));
        mutators.add((ctx, expression) -> ctx.fuzzChild(Expression.class, ExpressionMutatorProvider.ensureNotNull(ctx.randomness(), expression).getExpressionElement()));
        mutators.add((ctx, expression) -> ctx.fuzzChild(Expression.class, ExpressionMutatorProvider.ensureNotNull(ctx.randomness(), expression).getDescriptionElement()));
        mutators.add((ctx, expression) -> ctx.fuzzChild(Expression.class, ExpressionMutatorProvider.ensureNotNull(ctx.randomness(), expression).getLanguageElement()));
        mutators.add((ctx, expression) -> ctx.fuzzChild(Expression.class, ExpressionMutatorProvider.ensureNotNull(ctx.randomness(), expression).getNameElement()));
        mutators.add((ctx, expression) -> ctx.fuzzChild(Expression.class, ExpressionMutatorProvider.ensureNotNull(ctx.randomness(), expression).getReferenceElement()));
        return mutators;
    }

    private static Expression ensureNotNull(Randomness randomness, Expression expression) {
        if (expression == null) {
            expression = randomness.fhir().createType(Expression.class);
        }
        return expression;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Expression>> getMutators() {
        return this.mutators;
    }
}

