/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.ElementDefinition;

public class ElementDefinitionMutatorProvider
implements FhirTypeMutatorProvider<ElementDefinition> {
    private final List<FuzzingMutator<ElementDefinition>> mutators = ElementDefinitionMutatorProvider.createMutators();

    private static List<FuzzingMutator<ElementDefinition>> createMutators() {
        LinkedList<FuzzingMutator<ElementDefinition>> mutators = new LinkedList<FuzzingMutator<ElementDefinition>>();
        mutators.add((ctx, ed) -> ctx.fuzzIdElement(ElementDefinition.class, ed));
        mutators.add((ctx, ed) -> ctx.fuzzChildTypes(ElementDefinition.class, ElementDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), ed).getExtension()));
        mutators.add((ctx, ed) -> ctx.fuzzChildTypes(ElementDefinition.class, ElementDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), ed).getCode()));
        mutators.add((ctx, ed) -> ctx.fuzzChild(ElementDefinition.class, ElementDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), ed).getDefinitionElement()));
        mutators.add((ctx, ed) -> ctx.fuzzChild(ElementDefinition.class, ElementDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), ed).getMaxValue()));
        mutators.add((ctx, ed) -> ctx.fuzzChild(ElementDefinition.class, ElementDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), ed).getMaxElement()));
        mutators.add((ctx, ed) -> ctx.fuzzChild(ElementDefinition.class, ElementDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), ed).getMinValue()));
        mutators.add((ctx, ed) -> ctx.fuzzChild(ElementDefinition.class, ElementDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), ed).getMinElement()));
        mutators.add((ctx, ed) -> ctx.fuzzChild(ElementDefinition.class, ElementDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), ed).getCommentElement()));
        mutators.add((ctx, ed) -> ctx.fuzzChild(ElementDefinition.class, ElementDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), ed).getContentReferenceElement()));
        mutators.add((ctx, ed) -> ctx.fuzzChild(ElementDefinition.class, ElementDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), ed).getDefaultValue()));
        mutators.add((ctx, ed) -> ctx.fuzzChild(ElementDefinition.class, ElementDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), ed).getFixedOrPattern()));
        mutators.add((ctx, ed) -> ctx.fuzzChild(ElementDefinition.class, ElementDefinitionMutatorProvider.ensureNotNull(ctx.randomness(), ed).getLabelElement()));
        return mutators;
    }

    private static ElementDefinition ensureNotNull(Randomness randomness, ElementDefinition elementDefinition) {
        if (elementDefinition == null) {
            elementDefinition = randomness.fhir().createType(ElementDefinition.class);
        }
        return elementDefinition;
    }

    @Override
    @Generated
    public List<FuzzingMutator<ElementDefinition>> getMutators() {
        return this.mutators;
    }
}

