/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Dosage;

public class DosageMutatorProvider
implements FhirTypeMutatorProvider<Dosage> {
    private final List<FuzzingMutator<Dosage>> mutators = DosageMutatorProvider.createMutators();

    private static List<FuzzingMutator<Dosage>> createMutators() {
        LinkedList<FuzzingMutator<Dosage>> mutators = new LinkedList<FuzzingMutator<Dosage>>();
        mutators.add((ctx, dosage) -> ctx.fuzzIdElement(Dosage.class, dosage));
        mutators.add((ctx, dosage) -> ctx.fuzzChildTypes(Dosage.class, DosageMutatorProvider.ensureNotNull(ctx.randomness(), dosage).getExtension()));
        mutators.add((ctx, dosage) -> ctx.fuzzChild(Dosage.class, DosageMutatorProvider.ensureNotNull(ctx.randomness(), dosage).getAsNeeded()));
        mutators.add((ctx, dosage) -> ctx.fuzzChild(Dosage.class, DosageMutatorProvider.ensureNotNull(ctx.randomness(), dosage).getAsNeededCodeableConcept()));
        mutators.add((ctx, dosage) -> ctx.fuzzChildTypes(Dosage.class, DosageMutatorProvider.ensureNotNull(ctx.randomness(), dosage).getAdditionalInstruction()));
        mutators.add((ctx, dosage) -> ctx.fuzzChild(Dosage.class, DosageMutatorProvider.ensureNotNull(ctx.randomness(), dosage).getMaxDosePerAdministration()));
        mutators.add((ctx, dosage) -> ctx.fuzzChild(Dosage.class, DosageMutatorProvider.ensureNotNull(ctx.randomness(), dosage).getMaxDosePerLifetime()));
        mutators.add((ctx, dosage) -> ctx.fuzzChild(Dosage.class, DosageMutatorProvider.ensureNotNull(ctx.randomness(), dosage).getMaxDosePerPeriod()));
        mutators.add((ctx, dosage) -> ctx.fuzzChild(Dosage.class, DosageMutatorProvider.ensureNotNull(ctx.randomness(), dosage).getMethod()));
        mutators.add((ctx, dosage) -> ctx.fuzzChild(Dosage.class, DosageMutatorProvider.ensureNotNull(ctx.randomness(), dosage).getPatientInstructionElement()));
        mutators.add((ctx, dosage) -> ctx.fuzzChild(Dosage.class, DosageMutatorProvider.ensureNotNull(ctx.randomness(), dosage).getRoute()));
        mutators.add((ctx, dosage) -> ctx.fuzzChild(Dosage.class, DosageMutatorProvider.ensureNotNull(ctx.randomness(), dosage).getSequenceElement()));
        mutators.add((ctx, dosage) -> ctx.fuzzChild(Dosage.class, DosageMutatorProvider.ensureNotNull(ctx.randomness(), dosage).getSite()));
        mutators.add((ctx, dosage) -> ctx.fuzzChild(Dosage.class, DosageMutatorProvider.ensureNotNull(ctx.randomness(), dosage).getTextElement()));
        mutators.add((ctx, dosage) -> ctx.fuzzChild(Dosage.class, DosageMutatorProvider.ensureNotNull(ctx.randomness(), dosage).getTiming()));
        return mutators;
    }

    private static Dosage ensureNotNull(Randomness randomness, Dosage dosage) {
        if (dosage == null) {
            dosage = randomness.fhir().createType(Dosage.class);
        }
        return dosage;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Dosage>> getMutators() {
        return this.mutators;
    }
}

