/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.DecimalType;

public class DecimalTypeMutatorProvider
implements FhirTypeMutatorProvider<DecimalType> {
    private final List<FuzzingMutator<DecimalType>> mutators = DecimalTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<DecimalType>> createMutators() {
        LinkedList<FuzzingMutator<DecimalType>> mutators = new LinkedList<FuzzingMutator<DecimalType>>();
        mutators.add((ctx, decimalType) -> ctx.fuzzIdElement(DecimalType.class, decimalType));
        mutators.add((ctx, decimalType) -> ctx.fuzzChildTypes(DecimalType.class, DecimalTypeMutatorProvider.ensureNotNull(ctx.randomness(), decimalType).getExtension()));
        mutators.add((ctx, decimalType) -> {
            decimalType = DecimalTypeMutatorProvider.ensureNotNull(ctx.randomness(), decimalType);
            BigDecimal value = (BigDecimal)decimalType.getValue();
            BigDecimal fValue = value.negate();
            decimalType.setValue((Object)fValue);
            return FuzzingLogEntry.operation(MessageFormat.format("Negate value of DecimalType {0}", decimalType.getId()));
        });
        return mutators;
    }

    private static DecimalType ensureNotNull(Randomness randomness, DecimalType decimalType) {
        if (decimalType == null) {
            decimalType = randomness.fhir().createType(DecimalType.class);
        }
        if (decimalType.getValue() == null) {
            decimalType.setValue(randomness.source().nextLong());
        }
        return decimalType;
    }

    @Override
    @Generated
    public List<FuzzingMutator<DecimalType>> getMutators() {
        return this.mutators;
    }
}

