/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.DateType;

public class DateTypeMutatorProvider
implements FhirTypeMutatorProvider<DateType> {
    private final List<FuzzingMutator<DateType>> mutators = DateTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<DateType>> createMutators() {
        LinkedList<FuzzingMutator<DateType>> mutators = new LinkedList<FuzzingMutator<DateType>>();
        mutators.add((ctx, dt) -> ctx.fuzzIdElement(DateType.class, dt));
        mutators.add((ctx, dt) -> ctx.fuzzChildTypes(DateType.class, DateTypeMutatorProvider.ensureNotNull(ctx.randomness(), dt).getExtension()));
        mutators.add((ctx, dt) -> {
            dt = DateTypeMutatorProvider.ensureNotNull(ctx.randomness(), dt);
            Date date = ctx.randomness().date();
            TemporalPrecisionEnum precision = ctx.randomness().chooseRandomFromEnum(TemporalPrecisionEnum.class, List.of(TemporalPrecisionEnum.SECOND, TemporalPrecisionEnum.MILLI, TemporalPrecisionEnum.MINUTE));
            dt.setValue(date, precision);
            return FuzzingLogEntry.operation(MessageFormat.format("Change Date of DateType to {0}", dt.getValueAsString()));
        });
        return mutators;
    }

    private static DateType ensureNotNull(Randomness randomness, DateType dt) {
        if (dt == null) {
            TemporalPrecisionEnum precision = randomness.chooseRandomFromEnum(TemporalPrecisionEnum.class, List.of(TemporalPrecisionEnum.SECOND, TemporalPrecisionEnum.MILLI, TemporalPrecisionEnum.MINUTE));
            dt = randomness.fhir().createType(DateType.class);
            dt.setValue(randomness.date(), precision);
        }
        return dt;
    }

    @Override
    @Generated
    public List<FuzzingMutator<DateType>> getMutators() {
        return this.mutators;
    }
}

