/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.DateTimeType;

public class DateTimeTypeMutatorProvider
implements FhirTypeMutatorProvider<DateTimeType> {
    private final List<FuzzingMutator<DateTimeType>> mutators = DateTimeTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<DateTimeType>> createMutators() {
        LinkedList<FuzzingMutator<DateTimeType>> mutators = new LinkedList<FuzzingMutator<DateTimeType>>();
        mutators.add((ctx, dtt) -> ctx.fuzzIdElement(DateTimeType.class, dtt));
        mutators.add((ctx, dtt) -> ctx.fuzzChildTypes(DateTimeType.class, DateTimeTypeMutatorProvider.ensureNotNull(ctx.randomness(), dtt).getExtension()));
        mutators.add((ctx, dtt) -> {
            dtt = DateTimeTypeMutatorProvider.ensureNotNull(ctx.randomness(), dtt);
            Date date = ctx.randomness().date();
            TemporalPrecisionEnum precision = ctx.randomness().chooseRandomFromEnum(TemporalPrecisionEnum.class, TemporalPrecisionEnum.MINUTE);
            dtt.setValue(date, precision);
            return FuzzingLogEntry.operation(MessageFormat.format("Change Date of DateTimeType to {0}", dtt.getValueAsString()));
        });
        return mutators;
    }

    private static DateTimeType ensureNotNull(Randomness randomness, DateTimeType dtt) {
        if (dtt == null) {
            TemporalPrecisionEnum precision = randomness.chooseRandomFromEnum(TemporalPrecisionEnum.class, TemporalPrecisionEnum.MINUTE);
            dtt = randomness.fhir().createType(DateTimeType.class);
            dtt.setValue(randomness.date(), precision);
        }
        return dtt;
    }

    @Override
    @Generated
    public List<FuzzingMutator<DateTimeType>> getMutators() {
        return this.mutators;
    }
}

