/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.ResourceType;

public class DataRequirementMutatorProvider
implements FhirTypeMutatorProvider<DataRequirement> {
    private final List<FuzzingMutator<DataRequirement>> mutators = DataRequirementMutatorProvider.createMutators();

    private static List<FuzzingMutator<DataRequirement>> createMutators() {
        LinkedList<FuzzingMutator<DataRequirement>> mutators = new LinkedList<FuzzingMutator<DataRequirement>>();
        mutators.add((ctx, dr) -> ctx.fuzzIdElement(DataRequirement.class, dr));
        mutators.add((ctx, dr) -> ctx.fuzzChildTypes(DataRequirement.class, DataRequirementMutatorProvider.ensureNotNull(ctx.randomness(), dr).getExtension()));
        mutators.add((ctx, dr) -> ctx.fuzzChildTypes(DataRequirement.class, DataRequirementMutatorProvider.ensureNotNull(ctx.randomness(), dr).getMustSupport()));
        mutators.add((ctx, dr) -> ctx.fuzzChildTypes(DataRequirement.class, DataRequirementMutatorProvider.ensureNotNull(ctx.randomness(), dr).getProfile()));
        mutators.add((ctx, dr) -> ctx.fuzzChild(DataRequirement.class, DataRequirementMutatorProvider.ensureNotNull(ctx.randomness(), dr).getTypeElement()));
        mutators.add((ctx, dr) -> ctx.fuzzChild(DataRequirement.class, DataRequirementMutatorProvider.ensureNotNull(ctx.randomness(), dr).getLimitElement()));
        mutators.add((ctx, dr) -> ctx.fuzzChild(DataRequirement.class, DataRequirementMutatorProvider.ensureNotNull(ctx.randomness(), dr).getSubject()));
        mutators.add((ctx, dr) -> {
            DataRequirement fdr = dr = DataRequirementMutatorProvider.ensureNotNull(ctx.randomness(), dr);
            int amount = ctx.randomness().source().nextInt(1, 20);
            List<FuzzingLogEntry> fuzzLogs = IntStream.range(0, amount).mapToObj(idx -> {
                DataRequirement.DataRequirementSortComponent s = fdr.addSort();
                s.setDirection(ctx.randomness().chooseRandomFromEnum(DataRequirement.SortDirection.class));
                int pathLen = ctx.randomness().source().nextInt(1, 20);
                String path = IntStream.range(0, pathLen).mapToObj(plidx -> {
                    if (ctx.randomness().source().nextBoolean()) {
                        return MessageFormat.format("[{0}]", plidx);
                    }
                    return ctx.randomness().chooseRandomFromEnum(ResourceType.class).name();
                }).collect(Collectors.joining("."));
                s.setPath(path);
                return FuzzingLogEntry.operation(MessageFormat.format("Add new DataRequirementSortComponent: {0} for {1}", s.getDirection(), path));
            }).toList();
            return FuzzingLogEntry.parent(MessageFormat.format("Add {0} random SortComponents to DataRequirement with ID {1}", amount, fdr.getId()), fuzzLogs);
        });
        return mutators;
    }

    private static DataRequirement ensureNotNull(Randomness randomness, DataRequirement dataRequirement) {
        if (dataRequirement == null) {
            dataRequirement = randomness.fhir().createType(DataRequirement.class);
        }
        return dataRequirement;
    }

    @Override
    @Generated
    public List<FuzzingMutator<DataRequirement>> getMutators() {
        return this.mutators;
    }
}

