/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Contributor;

public class ContributorMutatorProvider
implements FhirTypeMutatorProvider<Contributor> {
    private final List<FuzzingMutator<Contributor>> mutators = ContributorMutatorProvider.createMutators();

    private static List<FuzzingMutator<Contributor>> createMutators() {
        LinkedList<FuzzingMutator<Contributor>> mutators = new LinkedList<FuzzingMutator<Contributor>>();
        mutators.add((ctx, contributor) -> ctx.fuzzIdElement(Contributor.class, contributor));
        mutators.add((ctx, contributor) -> ctx.fuzzChildTypes(Contributor.class, ContributorMutatorProvider.ensureNotNull(ctx.randomness(), contributor).getExtension()));
        mutators.add((ctx, contributor) -> ctx.fuzzChild(Contributor.class, ContributorMutatorProvider.ensureNotNull(ctx.randomness(), contributor).getNameElement()));
        mutators.add((ctx, contributor) -> ctx.fuzzChildTypes(Contributor.class, ContributorMutatorProvider.ensureNotNull(ctx.randomness(), contributor).getContact()));
        mutators.add((ctx, contributor) -> {
            contributor = ContributorMutatorProvider.ensureNotNull(ctx.randomness(), contributor);
            Contributor.ContributorType type = contributor.getType();
            Contributor.ContributorType ftype = ctx.randomness().chooseRandomFromEnum(Contributor.ContributorType.class, type);
            contributor.setType(ftype);
            return FuzzingLogEntry.operation(MessageFormat.format("Change Type of Contributor {0}: {1} -> {2}", contributor.getId(), type, ftype));
        });
        return mutators;
    }

    private static Contributor ensureNotNull(Randomness randomness, Contributor contributor) {
        if (contributor == null) {
            contributor = randomness.fhir().createType(Contributor.class);
        }
        return contributor;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Contributor>> getMutators() {
        return this.mutators;
    }
}

