/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.ContactPoint;

public class ContactPointMutatorProvider
implements FhirTypeMutatorProvider<ContactPoint> {
    private final List<FuzzingMutator<ContactPoint>> mutators = ContactPointMutatorProvider.createMutators();

    private static List<FuzzingMutator<ContactPoint>> createMutators() {
        LinkedList<FuzzingMutator<ContactPoint>> mutators = new LinkedList<FuzzingMutator<ContactPoint>>();
        mutators.add((ctx, cp) -> ctx.fuzzIdElement(ContactPoint.class, cp));
        mutators.add((ctx, cp) -> ctx.fuzzChildTypes(ContactPoint.class, ContactPointMutatorProvider.ensureNotNull(ctx.randomness(), cp).getExtension()));
        mutators.add((ctx, cp) -> ctx.fuzzChild(ContactPoint.class, ContactPointMutatorProvider.ensureNotNull(ctx.randomness(), cp).getValueElement()));
        mutators.add((ctx, cp) -> ctx.fuzzChild(ContactPoint.class, ContactPointMutatorProvider.ensureNotNull(ctx.randomness(), cp).getPeriod()));
        mutators.add((ctx, cp) -> ctx.fuzzChild(ContactPoint.class, ContactPointMutatorProvider.ensureNotNull(ctx.randomness(), cp).getRankElement()));
        mutators.add((ctx, cp) -> {
            cp = ContactPointMutatorProvider.ensureNotNull(ctx.randomness(), cp);
            ContactPoint.ContactPointUse ouse = cp.getUse();
            ContactPoint.ContactPointUse fuse = ctx.randomness().chooseRandomFromEnum(ContactPoint.ContactPointUse.class, ouse);
            cp.setUse(fuse);
            return FuzzingLogEntry.operation(MessageFormat.format("Change Use of ContactPoint {0}: {1} -> {2}", cp.getId(), ouse, fuse));
        });
        mutators.add((ctx, cp) -> {
            cp = ContactPointMutatorProvider.ensureNotNull(ctx.randomness(), cp);
            ContactPoint.ContactPointSystem osys = cp.getSystem();
            ContactPoint.ContactPointSystem fsys = ctx.randomness().chooseRandomFromEnum(ContactPoint.ContactPointSystem.class, osys);
            cp.setSystem(fsys);
            return FuzzingLogEntry.operation(MessageFormat.format("Change System of ContactPoint {0}: {1} -> {2}", cp.getId(), osys, fsys));
        });
        return mutators;
    }

    private static ContactPoint ensureNotNull(Randomness randomness, ContactPoint cp) {
        if (cp == null) {
            cp = randomness.fhir().createType(ContactPoint.class);
        }
        return cp;
    }

    @Override
    @Generated
    public List<FuzzingMutator<ContactPoint>> getMutators() {
        return this.mutators;
    }
}

