/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Coding;

public class CodingMutatorProvider
implements FhirTypeMutatorProvider<Coding> {
    private final List<FuzzingMutator<Coding>> mutators = CodingMutatorProvider.createMutators();

    private static List<FuzzingMutator<Coding>> createMutators() {
        LinkedList<FuzzingMutator<Coding>> mutators = new LinkedList<FuzzingMutator<Coding>>();
        mutators.add((ctx, coding) -> ctx.fuzzIdElement(Coding.class, coding));
        mutators.add((ctx, coding) -> ctx.fuzzChildTypes(Coding.class, CodingMutatorProvider.ensureNotNull(ctx.randomness(), coding).getExtension()));
        mutators.add((ctx, coding) -> ctx.fuzzChild(Coding.class, CodingMutatorProvider.ensureNotNull(ctx.randomness(), coding).getCodeElement()));
        mutators.add((ctx, coding) -> ctx.fuzzChild(Coding.class, CodingMutatorProvider.ensureNotNull(ctx.randomness(), coding).getDisplayElement()));
        mutators.add((ctx, coding) -> ctx.fuzzChild(Coding.class, CodingMutatorProvider.ensureNotNull(ctx.randomness(), coding).getVersionElement()));
        mutators.add((ctx, coding) -> ctx.fuzzChild(Coding.class, CodingMutatorProvider.ensureNotNull(ctx.randomness(), coding).getUserSelectedElement()));
        mutators.add((ctx, coding) -> {
            coding = CodingMutatorProvider.ensureNotNull(ctx.randomness(), coding);
            String version = ctx.randomness().version();
            coding.setVersion(version);
            return FuzzingLogEntry.operation(MessageFormat.format("Set random Version {0} to Coding {1} {2}", version, coding.getSystem(), coding.getCode()));
        });
        return mutators;
    }

    private static Coding ensureNotNull(Randomness randomness, Coding coding) {
        if (coding == null) {
            coding = randomness.fhir().createType(Coding.class);
        }
        return coding;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Coding>> getMutators() {
        return this.mutators;
    }
}

