/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.StringType;

public class CodeableConceptTypeMutatorProvider
implements FhirTypeMutatorProvider<CodeableConcept> {
    private final List<FuzzingMutator<CodeableConcept>> mutators = CodeableConceptTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<CodeableConcept>> createMutators() {
        LinkedList<FuzzingMutator<CodeableConcept>> mutators = new LinkedList<FuzzingMutator<CodeableConcept>>();
        mutators.add((ctx, cc) -> ctx.fuzzIdElement(CodeableConcept.class, cc));
        mutators.add((ctx, cc) -> ctx.fuzzChildTypes(CodeableConcept.class, CodeableConceptTypeMutatorProvider.ensureNotNull(ctx.randomness(), cc).getCoding()));
        mutators.add((ctx, cc) -> ctx.fuzzChildTypes(CodeableConcept.class, CodeableConceptTypeMutatorProvider.ensureNotNull(ctx.randomness(), cc).getExtension()));
        mutators.add((ctx, cc) -> ctx.fuzzChild(CodeableConcept.class, CodeableConceptTypeMutatorProvider.ensureNotNull(ctx.randomness(), cc).getTextElement()));
        mutators.add((ctx, cc) -> {
            cc = CodeableConceptTypeMutatorProvider.ensureNotNull(ctx.randomness(), cc);
            cc.setText(ctx.randomness().regexify("[A-Za-z0-9._%$+-]{1,10}"));
            return FuzzingLogEntry.operation(MessageFormat.format("Set random Text to CodeableConcept: {0}", cc.getText()));
        });
        mutators.add((ctx, cc) -> {
            cc = CodeableConceptTypeMutatorProvider.ensureNotNull(ctx.randomness(), cc);
            Coding coding = cc.addCoding();
            FuzzingLogEntry codingFuzz = ctx.fuzzChild(CodeableConcept.class, coding);
            return FuzzingLogEntry.parent(MessageFormat.format("Add random coding to CodeableConcept {0}", cc.getId()), codingFuzz);
        });
        mutators.add((ctx, cc) -> {
            cc = CodeableConceptTypeMutatorProvider.ensureNotNull(ctx.randomness(), cc);
            StringType textElement = cc.getTextElement();
            FuzzingLogEntry textElementFuzz = ctx.fuzzChild(CodeableConcept.class, textElement);
            return FuzzingLogEntry.parent(MessageFormat.format("Add random text element to CodeableConcept {0}", cc.getId()), textElementFuzz);
        });
        return mutators;
    }

    private static CodeableConcept ensureNotNull(Randomness randomness, CodeableConcept cc) {
        if (cc == null) {
            cc = randomness.fhir().createType(CodeableConcept.class);
        }
        return cc;
    }

    @Override
    @Generated
    public List<FuzzingMutator<CodeableConcept>> getMutators() {
        return this.mutators;
    }
}

