/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveStringTypes;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeFuzzingResponse;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.CodeType;

public class CodeTypeMutatorProvider
implements FhirTypeMutatorProvider<CodeType> {
    private final List<FuzzingMutator<CodeType>> mutators = CodeTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<CodeType>> createMutators() {
        LinkedList<FuzzingMutator<CodeType>> mutators = new LinkedList<FuzzingMutator<CodeType>>();
        mutators.add((ctx, codeType) -> ctx.fuzzIdElement(CodeType.class, codeType));
        mutators.add((ctx, codeType) -> ctx.fuzzChildTypes(CodeType.class, CodeTypeMutatorProvider.ensureNotNull(ctx.randomness(), codeType).getExtension()));
        mutators.add((ctx, codeType) -> {
            codeType = CodeTypeMutatorProvider.ensureNotNull(ctx.randomness(), codeType);
            String code = codeType.getCode();
            PrimitiveTypeFuzzingResponse<String> response = ctx.fuzzPrimitiveType(MessageFormat.format("Fuzz CodeType code {0}", code), PrimitiveStringTypes.CODE, code);
            codeType.setValue((Object)response.getFuzzedValue());
            return response.getLogEntry();
        });
        mutators.add((ctx, codeType) -> {
            codeType = CodeTypeMutatorProvider.ensureNotNull(ctx.randomness(), codeType);
            String system = codeType.getSystem();
            PrimitiveTypeFuzzingResponse<String> response = ctx.fuzzPrimitiveType(MessageFormat.format("Fuzz CodeType system {0}", system), PrimitiveStringTypes.URI, system);
            codeType.setValue((Object)response.getFuzzedValue());
            return response.getLogEntry();
        });
        return mutators;
    }

    private static CodeType ensureNotNull(Randomness randomness, CodeType codeType) {
        if (codeType == null) {
            codeType = randomness.fhir().createType(CodeType.class);
        }
        return codeType;
    }

    @Override
    @Generated
    public List<FuzzingMutator<CodeType>> getMutators() {
        return this.mutators;
    }
}

