/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Type;

public class CanonicalTypeMutatorProvider
implements FhirTypeMutatorProvider<CanonicalType> {
    private final List<FuzzingMutator<CanonicalType>> mutators = CanonicalTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<CanonicalType>> createMutators() {
        LinkedList<FuzzingMutator<CanonicalType>> mutators = new LinkedList<FuzzingMutator<CanonicalType>>();
        mutators.add((ctx, canonicalType) -> ctx.fuzzIdElement(CanonicalType.class, canonicalType));
        mutators.add((ctx, canonicalType) -> ctx.fuzzChildTypes(CanonicalType.class, CanonicalTypeMutatorProvider.ensureNotNull(ctx.randomness(), canonicalType).getExtension()));
        mutators.add((ctx, canonicalType) -> {
            canonicalType = CanonicalTypeMutatorProvider.ensureNotNull(ctx.randomness(), canonicalType);
            String url = ctx.randomness().url();
            Type type = ctx.randomness().fhir().createType();
            LinkedList extensions = new LinkedList(canonicalType.getExtension());
            canonicalType.setExtension(extensions);
            canonicalType.addExtension(url, type);
            return FuzzingLogEntry.operation(MessageFormat.format("Add random Extension to CanonicalType {0}: {1} / {2}", canonicalType.getId(), url, type));
        });
        return mutators;
    }

    private static CanonicalType ensureNotNull(Randomness randomness, CanonicalType canonicalType) {
        if (canonicalType == null) {
            canonicalType = randomness.fhir().createType(CanonicalType.class);
        }
        return canonicalType;
    }

    @Override
    @Generated
    public List<FuzzingMutator<CanonicalType>> getMutators() {
        return this.mutators;
    }
}

