/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.BooleanType;

public class BooleanTypeMutatorProvider
implements FhirTypeMutatorProvider<BooleanType> {
    private final List<FuzzingMutator<BooleanType>> mutators = BooleanTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<BooleanType>> createMutators() {
        LinkedList<FuzzingMutator<BooleanType>> mutators = new LinkedList<FuzzingMutator<BooleanType>>();
        mutators.add((ctx, bt) -> ctx.fuzzIdElement(BooleanType.class, bt));
        mutators.add((ctx, bt) -> ctx.fuzzChildTypes(BooleanType.class, BooleanTypeMutatorProvider.ensureNotNull(ctx.randomness(), bt).getExtension()));
        mutators.add((ctx, bt) -> {
            boolean original = (bt = BooleanTypeMutatorProvider.ensureNotNull(ctx.randomness(), bt)).booleanValue();
            bt.setValue((Object)(!original ? 1 : 0));
            return FuzzingLogEntry.operation("Flip BooleanType value");
        });
        return mutators;
    }

    private static BooleanType ensureNotNull(Randomness randomness, BooleanType booleanType) {
        if (booleanType == null) {
            booleanType = randomness.fhir().createType(BooleanType.class);
            booleanType.setValue((Object)randomness.source().nextBoolean());
        }
        if (booleanType.getValue() == null) {
            booleanType.setValue((Object)randomness.source().nextBoolean());
        }
        return booleanType;
    }

    @Override
    @Generated
    public List<FuzzingMutator<BooleanType>> getMutators() {
        return this.mutators;
    }
}

