/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveStringTypes;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeFuzzingResponse;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Base64BinaryType;

public class Base64BinaryTypeMutatorProvider
implements FhirTypeMutatorProvider<Base64BinaryType> {
    private final List<FuzzingMutator<Base64BinaryType>> mutators = Base64BinaryTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<Base64BinaryType>> createMutators() {
        LinkedList<FuzzingMutator<Base64BinaryType>> mutators = new LinkedList<FuzzingMutator<Base64BinaryType>>();
        mutators.add((ctx, bt) -> ctx.fuzzIdElement(Base64BinaryType.class, bt));
        mutators.add((ctx, bt) -> ctx.fuzzChildTypes(Base64BinaryType.class, Base64BinaryTypeMutatorProvider.ensureNotNull(ctx.randomness(), bt).getExtension()));
        mutators.add((ctx, bt) -> {
            bt = Base64BinaryTypeMutatorProvider.ensureNotNull(ctx.randomness(), bt);
            String value = new String(bt.getValue());
            PrimitiveTypeFuzzingResponse<String> fresponse = ctx.fuzzPrimitiveType("Fuzz Base64Binary as plain String", PrimitiveStringTypes.TEXT, value);
            bt.setValue(fresponse.getFuzzedValue().getBytes());
            return fresponse.getLogEntry();
        });
        return mutators;
    }

    private static Base64BinaryType ensureNotNull(Randomness randomness, Base64BinaryType b64bt) {
        if (b64bt == null) {
            b64bt = randomness.fhir().createType(Base64BinaryType.class);
        }
        if (!b64bt.hasValue()) {
            int amount = randomness.source().nextInt(1, 100);
            byte[] value = new byte[amount];
            randomness.source().nextBytes(value);
            b64bt.setValue(value);
        }
        return b64bt;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Base64BinaryType>> getMutators() {
        return this.mutators;
    }
}

