/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Attachment;

public class AttachmentMutatorProvider
implements FhirTypeMutatorProvider<Attachment> {
    private final List<FuzzingMutator<Attachment>> mutators = AttachmentMutatorProvider.createMutators();

    private static List<FuzzingMutator<Attachment>> createMutators() {
        LinkedList<FuzzingMutator<Attachment>> mutators = new LinkedList<FuzzingMutator<Attachment>>();
        mutators.add((ctx, attachment) -> ctx.fuzzIdElement(Attachment.class, attachment));
        mutators.add((ctx, attachment) -> ctx.fuzzChildTypes(Attachment.class, AttachmentMutatorProvider.ensureNotNull(ctx.randomness(), attachment).getExtension()));
        mutators.add((ctx, attachment) -> ctx.fuzzChild(Attachment.class, AttachmentMutatorProvider.ensureNotNull(ctx.randomness(), attachment).getCreationElement()));
        mutators.add((ctx, attachment) -> ctx.fuzzChild(Attachment.class, AttachmentMutatorProvider.ensureNotNull(ctx.randomness(), attachment).getDataElement()));
        mutators.add((ctx, attachment) -> ctx.fuzzChild(Attachment.class, AttachmentMutatorProvider.ensureNotNull(ctx.randomness(), attachment).getContentTypeElement()));
        mutators.add((ctx, attachment) -> ctx.fuzzChild(Attachment.class, AttachmentMutatorProvider.ensureNotNull(ctx.randomness(), attachment).getHashElement()));
        mutators.add((ctx, attachment) -> ctx.fuzzChild(Attachment.class, AttachmentMutatorProvider.ensureNotNull(ctx.randomness(), attachment).getLanguageElement()));
        mutators.add((ctx, attachment) -> ctx.fuzzChild(Attachment.class, AttachmentMutatorProvider.ensureNotNull(ctx.randomness(), attachment).getSizeElement()));
        mutators.add((ctx, attachment) -> ctx.fuzzChild(Attachment.class, AttachmentMutatorProvider.ensureNotNull(ctx.randomness(), attachment).getTitleElement()));
        mutators.add((ctx, attachment) -> ctx.fuzzChild(Attachment.class, AttachmentMutatorProvider.ensureNotNull(ctx.randomness(), attachment).getUrlElement()));
        return mutators;
    }

    private static Attachment ensureNotNull(Randomness randomness, Attachment attachment) {
        if (attachment == null) {
            attachment = randomness.fhir().createType(Attachment.class);
        }
        return attachment;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Attachment>> getMutators() {
        return this.mutators;
    }
}

