/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Annotation;

public class AnnotationMutatorProvider
implements FhirTypeMutatorProvider<Annotation> {
    private final List<FuzzingMutator<Annotation>> mutators = AnnotationMutatorProvider.createMutators();

    private static List<FuzzingMutator<Annotation>> createMutators() {
        LinkedList<FuzzingMutator<Annotation>> mutators = new LinkedList<FuzzingMutator<Annotation>>();
        mutators.add((ctx, annotation) -> ctx.fuzzIdElement(Annotation.class, annotation));
        mutators.add((ctx, annotation) -> ctx.fuzzChildTypes(Annotation.class, AnnotationMutatorProvider.ensureNotNull(ctx.randomness(), annotation).getExtension()));
        mutators.add((ctx, annotation) -> ctx.fuzzChild(Annotation.class, AnnotationMutatorProvider.ensureNotNull(ctx.randomness(), annotation).getAuthor()));
        mutators.add((ctx, annotation) -> ctx.fuzzChild(Annotation.class, AnnotationMutatorProvider.ensureNotNull(ctx.randomness(), annotation).getTimeElement()));
        mutators.add((ctx, annotation) -> ctx.fuzzChild(Annotation.class, AnnotationMutatorProvider.ensureNotNull(ctx.randomness(), annotation).getTextElement()));
        return mutators;
    }

    private static Annotation ensureNotNull(Randomness randomness, Annotation annotation) {
        if (annotation == null) {
            annotation = randomness.fhir().createType(Annotation.class);
        }
        return annotation;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Annotation>> getMutators() {
        return this.mutators;
    }
}

