/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Address;

public class AddressTypeMutatorProvider
implements FhirTypeMutatorProvider<Address> {
    private final List<FuzzingMutator<Address>> mutators = AddressTypeMutatorProvider.createMutators();

    private static List<FuzzingMutator<Address>> createMutators() {
        LinkedList<FuzzingMutator<Address>> mutators = new LinkedList<FuzzingMutator<Address>>();
        mutators.add((ctx, address) -> ctx.fuzzIdElement(Address.class, address));
        mutators.add((ctx, address) -> ctx.fuzzChildTypes(Address.class, AddressTypeMutatorProvider.ensureNotNull(ctx.randomness(), address).getExtension()));
        mutators.add((ctx, address) -> ctx.fuzzChildTypes(Address.class, AddressTypeMutatorProvider.ensureNotNull(ctx.randomness(), address).getLine()));
        mutators.add((ctx, address) -> ctx.fuzzChild(Address.class, AddressTypeMutatorProvider.ensureNotNull(ctx.randomness(), address).getCityElement()));
        mutators.add((ctx, address) -> ctx.fuzzChild(Address.class, AddressTypeMutatorProvider.ensureNotNull(ctx.randomness(), address).getCountryElement()));
        mutators.add((ctx, address) -> ctx.fuzzChild(Address.class, AddressTypeMutatorProvider.ensureNotNull(ctx.randomness(), address).getDistrictElement()));
        mutators.add((ctx, address) -> ctx.fuzzChild(Address.class, AddressTypeMutatorProvider.ensureNotNull(ctx.randomness(), address).getPostalCodeElement()));
        mutators.add((ctx, address) -> ctx.fuzzChild(Address.class, AddressTypeMutatorProvider.ensureNotNull(ctx.randomness(), address).getStateElement()));
        mutators.add((ctx, address) -> ctx.fuzzChild(Address.class, AddressTypeMutatorProvider.ensureNotNull(ctx.randomness(), address).getTextElement()));
        mutators.add((ctx, address) -> ctx.fuzzChild(Address.class, AddressTypeMutatorProvider.ensureNotNull(ctx.randomness(), address).getPeriod()));
        mutators.add((ctx, address) -> {
            address = AddressTypeMutatorProvider.ensureNotNull(ctx.randomness(), address);
            String oc = address.getCountry();
            String fc = oc + ctx.randomness().regexify("[A-Z]{1,2}");
            address.setCountry(fc);
            return FuzzingLogEntry.operation(MessageFormat.format("Change Address Country value: {0} -> {1}", oc, fc));
        });
        mutators.add((ctx, address) -> {
            address = AddressTypeMutatorProvider.ensureNotNull(ctx.randomness(), address);
            String country = address.getCountry();
            String postalCode = address.getPostalCode();
            address.setCountry(postalCode);
            address.setPostalCode(country);
            return FuzzingLogEntry.operation(MessageFormat.format("Flip Address Country and PostalCode values: {0} <-> {1}", country, postalCode));
        });
        mutators.add((ctx, address) -> {
            address = AddressTypeMutatorProvider.ensureNotNull(ctx.randomness(), address);
            Address.AddressType oat = address.getType() == null ? Address.AddressType.NULL : address.getType();
            Address.AddressType fat = ctx.randomness().chooseRandomFromEnum(Address.AddressType.class, oat);
            address.setType(fat);
            return FuzzingLogEntry.operation(MessageFormat.format("Change AddressType: {0} -> {1}", oat, fat));
        });
        return mutators;
    }

    private static Address ensureNotNull(Randomness randomness, Address address) {
        if (address == null) {
            address = randomness.fhir().createType(Address.class);
        }
        return address;
    }

    @Override
    @Generated
    public List<FuzzingMutator<Address>> getMutators() {
        return this.mutators;
    }
}

