/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Task;

public class TaskMutatorProvider
extends BaseDomainResourceMutatorProvider<Task> {
    public TaskMutatorProvider() {
        super(TaskMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Task>> createMutators() {
        LinkedList<FuzzingMutator<Task>> mutators = new LinkedList<FuzzingMutator<Task>>();
        mutators.add((ctx, task) -> ctx.fuzzChildTypes(task.getClass(), task.getIdentifier(), () -> ((Task)task).getIdentifierFirstRep()));
        mutators.add((ctx, task) -> ctx.fuzzChildTypes(task.getClass(), task.getNote(), () -> ((Task)task).getNoteFirstRep()));
        mutators.add((ctx, task) -> ctx.fuzzChildTypes(task.getClass(), task.getBasedOn(), () -> ((Task)task).getBasedOnFirstRep()));
        mutators.add((ctx, task) -> ctx.fuzzChildTypes(task.getClass(), task.getInsurance(), () -> ((Task)task).getInsuranceFirstRep()));
        mutators.add((ctx, task) -> ctx.fuzzChildTypes(task.getClass(), task.getPartOf(), () -> ((Task)task).getPartOfFirstRep()));
        mutators.add((ctx, task) -> ctx.fuzzChildTypes(task.getClass(), task.getPerformerType(), () -> ((Task)task).getPerformerTypeFirstRep()));
        mutators.add((ctx, task) -> ctx.fuzzChildTypes(task.getClass(), task.getRelevantHistory(), () -> ((Task)task).getRelevantHistoryFirstRep()));
        mutators.add((ctx, task) -> ctx.fuzzChild(task, () -> ((Task)task).hasAuthoredOn(), () -> ((Task)task).getAuthoredOnElement()));
        mutators.add((ctx, task) -> ctx.fuzzChild(task, () -> ((Task)task).hasBusinessStatus(), () -> ((Task)task).getBusinessStatus()));
        mutators.add((ctx, task) -> ctx.fuzzChild(task, () -> ((Task)task).hasCode(), () -> ((Task)task).getCode()));
        mutators.add((ctx, task) -> ctx.fuzzChild(task, () -> ((Task)task).hasEncounter(), () -> ((Task)task).getEncounter()));
        mutators.add((ctx, task) -> ctx.fuzzChild(task, () -> ((Task)task).hasDescription(), () -> ((Task)task).getDescriptionElement()));
        mutators.add((ctx, task) -> ctx.fuzzChild(task, () -> ((Task)task).hasReasonCode(), () -> ((Task)task).getReasonCode()));
        mutators.add((ctx, task) -> ctx.fuzzChild(task, () -> ((Task)task).hasRequester(), () -> ((Task)task).getRequester()));
        mutators.add((ctx, task) -> ctx.fuzzChild(task, () -> ((Task)task).hasExecutionPeriod(), () -> ((Task)task).getExecutionPeriod()));
        mutators.add((ctx, task) -> ctx.fuzzChild(task, () -> ((Task)task).hasFocus(), () -> ((Task)task).getFocus()));
        mutators.add((ctx, task) -> ctx.fuzzChild(task, () -> ((Task)task).hasFor(), () -> ((Task)task).getFor()));
        mutators.add((ctx, task) -> ctx.fuzzChild(task, () -> ((Task)task).hasInstantiatesCanonical(), () -> ((Task)task).getInstantiatesCanonicalElement()));
        mutators.add((ctx, task) -> ctx.fuzzChild(task, () -> ((Task)task).hasInstantiatesUriElement(), () -> ((Task)task).getInstantiatesUriElement()));
        return mutators;
    }
}

