/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.hl7.fhir.r4.model.SupplyRequest;
import org.hl7.fhir.r4.model.Type;

public class SupplyRequestMutatorProvider
extends BaseDomainResourceMutatorProvider<SupplyRequest> {
    public SupplyRequestMutatorProvider() {
        super(SupplyRequestMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<SupplyRequest>> createMutators() {
        LinkedList<FuzzingMutator<SupplyRequest>> mutators = new LinkedList<FuzzingMutator<SupplyRequest>>();
        mutators.add((ctx, sr) -> ctx.fuzzChildTypes(sr.getClass(), sr.getIdentifier(), () -> ((SupplyRequest)sr).getIdentifierFirstRep()));
        mutators.add((ctx, sr) -> ctx.fuzzChildTypes(sr.getClass(), sr.getReasonCode(), () -> ((SupplyRequest)sr).getReasonCodeFirstRep()));
        mutators.add((ctx, sr) -> ctx.fuzzChildTypes(sr.getClass(), sr.getSupplier(), () -> ((SupplyRequest)sr).getSupplierFirstRep()));
        mutators.add((ctx, sr) -> ctx.fuzzChild(sr, () -> ((SupplyRequest)sr).hasAuthoredOn(), () -> ((SupplyRequest)sr).getAuthoredOnElement()));
        mutators.add((ctx, sr) -> ctx.fuzzChild(sr, () -> ((SupplyRequest)sr).hasRequester(), () -> ((SupplyRequest)sr).getRequester()));
        mutators.add((ctx, sr) -> ctx.fuzzChild(sr, () -> ((SupplyRequest)sr).hasCategory(), () -> ((SupplyRequest)sr).getCategory()));
        mutators.add((ctx, sr) -> ctx.fuzzChild(sr, () -> ((SupplyRequest)sr).hasDeliverFrom(), () -> ((SupplyRequest)sr).getDeliverFrom()));
        mutators.add((ctx, sr) -> ctx.fuzzChild(sr, () -> ((SupplyRequest)sr).hasDeliverTo(), () -> ((SupplyRequest)sr).getDeliverTo()));
        mutators.add((ctx, sr) -> ctx.fuzzChild(sr, () -> ((SupplyRequest)sr).hasQuantity(), () -> ((SupplyRequest)sr).getQuantity()));
        mutators.add((ctx, sr) -> {
            if (sr.hasOccurrence()) {
                return ctx.fuzzChild(sr, true, () -> ((SupplyRequest)sr).getOccurrence());
            }
            Supplier<Type> supplier = ctx.randomness().chooseRandomElement(List.of(() -> ((SupplyRequest)sr).getOccurrencePeriod(), () -> ((SupplyRequest)sr).getOccurrenceTiming(), () -> ((SupplyRequest)sr).getOccurrenceDateTimeType()));
            return ctx.fuzzChild(sr, false, supplier);
        });
        mutators.add((ctx, sr) -> {
            if (sr.hasItem()) {
                return ctx.fuzzChild(sr, true, () -> ((SupplyRequest)sr).getItem());
            }
            Supplier<Type> supplier = ctx.randomness().chooseRandomElement(List.of(() -> ((SupplyRequest)sr).getItemReference(), () -> ((SupplyRequest)sr).getItemCodeableConcept()));
            return ctx.fuzzChild(sr, false, supplier);
        });
        return mutators;
    }
}

