/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.hl7.fhir.r4.model.SupplyDelivery;
import org.hl7.fhir.r4.model.Type;

public class SupplyDeliveryMutatorProvider
extends BaseDomainResourceMutatorProvider<SupplyDelivery> {
    public SupplyDeliveryMutatorProvider() {
        super(SupplyDeliveryMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<SupplyDelivery>> createMutators() {
        LinkedList<FuzzingMutator<SupplyDelivery>> mutators = new LinkedList<FuzzingMutator<SupplyDelivery>>();
        mutators.add((ctx, sd) -> ctx.fuzzChildTypes(sd.getClass(), sd.getIdentifier(), () -> ((SupplyDelivery)sd).getIdentifierFirstRep()));
        mutators.add((ctx, sd) -> ctx.fuzzChildTypes(sd.getClass(), sd.getBasedOn(), () -> ((SupplyDelivery)sd).getBasedOnFirstRep()));
        mutators.add((ctx, sd) -> ctx.fuzzChildTypes(sd.getClass(), sd.getPartOf(), () -> ((SupplyDelivery)sd).getPartOfFirstRep()));
        mutators.add((ctx, sd) -> ctx.fuzzChildTypes(sd.getClass(), sd.getReceiver(), () -> ((SupplyDelivery)sd).getReceiverFirstRep()));
        mutators.add((ctx, sd) -> ctx.fuzzChild(sd, () -> ((SupplyDelivery)sd).hasSupplier(), () -> ((SupplyDelivery)sd).getSupplier()));
        mutators.add((ctx, sd) -> ctx.fuzzChild(sd, () -> ((SupplyDelivery)sd).hasType(), () -> ((SupplyDelivery)sd).getType()));
        mutators.add((ctx, sd) -> ctx.fuzzChild(sd, () -> ((SupplyDelivery)sd).hasDestination(), () -> ((SupplyDelivery)sd).getDestination()));
        mutators.add((ctx, sd) -> ctx.fuzzChild(sd, () -> ((SupplyDelivery)sd).hasPatient(), () -> ((SupplyDelivery)sd).getPatient()));
        mutators.add((ctx, sd) -> {
            if (sd.hasOccurrence()) {
                return ctx.fuzzChild(sd, true, () -> ((SupplyDelivery)sd).getOccurrence());
            }
            Supplier<Type> supplier = ctx.randomness().chooseRandomElement(List.of(() -> ((SupplyDelivery)sd).getOccurrencePeriod(), () -> ((SupplyDelivery)sd).getOccurrenceTiming(), () -> ((SupplyDelivery)sd).getOccurrenceDateTimeType()));
            return ctx.fuzzChild(sd, false, supplier);
        });
        mutators.add((ctx, sd) -> {
            SupplyDelivery.SupplyDeliveryStatus status = sd.getStatus();
            SupplyDelivery.SupplyDeliveryStatus fstatus = ctx.randomness().chooseRandomFromEnum(SupplyDelivery.SupplyDeliveryStatus.class, status);
            sd.setStatus(fstatus);
            return FuzzingLogEntry.operation(MessageFormat.format("Change Status of SupplyDelivery {0}: {1} -> {2}", sd.getId(), status, fstatus));
        });
        return mutators;
    }
}

