/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Specimen;

public class SpecimenMutatorProvider
extends BaseDomainResourceMutatorProvider<Specimen> {
    public SpecimenMutatorProvider() {
        super(SpecimenMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Specimen>> createMutators() {
        LinkedList<FuzzingMutator<Specimen>> mutators = new LinkedList<FuzzingMutator<Specimen>>();
        mutators.add((ctx, spec) -> ctx.fuzzChildTypes(spec.getClass(), spec.getCondition(), () -> ((Specimen)spec).getConditionFirstRep()));
        mutators.add((ctx, spec) -> ctx.fuzzChildTypes(spec.getClass(), spec.getIdentifier(), () -> ((Specimen)spec).getIdentifierFirstRep()));
        mutators.add((ctx, spec) -> ctx.fuzzChildTypes(spec.getClass(), spec.getNote(), () -> ((Specimen)spec).getNoteFirstRep()));
        mutators.add((ctx, spec) -> ctx.fuzzChildTypes(spec.getClass(), spec.getParent(), () -> ((Specimen)spec).getParentFirstRep()));
        mutators.add((ctx, spec) -> ctx.fuzzChildTypes(spec.getClass(), spec.getRequest(), () -> ((Specimen)spec).getRequestFirstRep()));
        mutators.add((ctx, spec) -> ctx.fuzzChild(spec, () -> ((Specimen)spec).hasType(), () -> ((Specimen)spec).getType()));
        mutators.add((ctx, spec) -> ctx.fuzzChild(spec, () -> ((Specimen)spec).hasAccessionIdentifier(), () -> ((Specimen)spec).getAccessionIdentifier()));
        mutators.add((ctx, spec) -> ctx.fuzzChild(spec, () -> ((Specimen)spec).hasReceivedTime(), () -> ((Specimen)spec).getReceivedTimeElement()));
        mutators.add((ctx, spec) -> ctx.fuzzChild(spec, () -> ((Specimen)spec).hasSubject(), () -> ((Specimen)spec).getSubject()));
        return mutators;
    }
}

