/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Type;

public class ProvenanceMutatorProvider
extends BaseDomainResourceMutatorProvider<Provenance> {
    public ProvenanceMutatorProvider() {
        super(ProvenanceMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Provenance>> createMutators() {
        LinkedList<FuzzingMutator<Provenance>> mutators = new LinkedList<FuzzingMutator<Provenance>>();
        mutators.add((ctx, prov) -> ctx.fuzzChildTypes(prov.getClass(), prov.getPolicy(), () -> ((Provenance)prov).addPolicyElement()));
        mutators.add((ctx, prov) -> ctx.fuzzChildTypes(prov.getClass(), prov.getReason(), () -> ((Provenance)prov).getReasonFirstRep()));
        mutators.add((ctx, prov) -> ctx.fuzzChildTypes(prov.getClass(), prov.getSignature(), () -> ((Provenance)prov).getSignatureFirstRep()));
        mutators.add((ctx, prov) -> ctx.fuzzChildTypes(prov.getClass(), prov.getTarget(), () -> ((Provenance)prov).getTargetFirstRep()));
        mutators.add((ctx, prov) -> ctx.fuzzChild(prov, () -> ((Provenance)prov).hasActivity(), () -> ((Provenance)prov).getActivity()));
        mutators.add((ctx, prov) -> ctx.fuzzChild(prov, () -> ((Provenance)prov).hasLocation(), () -> ((Provenance)prov).getLocation()));
        mutators.add((ctx, prov) -> ctx.fuzzChild(prov, () -> ((Provenance)prov).hasRecorded(), () -> ((Provenance)prov).getRecordedElement()));
        mutators.add((ctx, prov) -> {
            if (prov.hasOccurred()) {
                return ctx.fuzzChild(prov, true, () -> ((Provenance)prov).getOccurred());
            }
            Supplier<Type> supplier = ctx.randomness().chooseRandomElement(List.of(() -> ((Provenance)prov).getOccurredDateTimeType(), () -> ((Provenance)prov).getOccurredPeriod()));
            return ctx.fuzzChild(prov, false, supplier);
        });
        return mutators;
    }
}

