/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Practitioner;

public class PractitionerMutatorProvider
extends BaseDomainResourceMutatorProvider<Practitioner> {
    public PractitionerMutatorProvider() {
        super(PractitionerMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Practitioner>> createMutators() {
        LinkedList<FuzzingMutator<Practitioner>> mutators = new LinkedList<FuzzingMutator<Practitioner>>();
        mutators.add((ctx, pract) -> ctx.fuzzChildTypes(pract.getClass(), pract.getAddress(), () -> ((Practitioner)pract).getAddressFirstRep()));
        mutators.add((ctx, pract) -> ctx.fuzzChildTypes(pract.getClass(), pract.getIdentifier(), () -> ((Practitioner)pract).getIdentifierFirstRep()));
        mutators.add((ctx, pract) -> ctx.fuzzChildTypes(pract.getClass(), pract.getName(), () -> ((Practitioner)pract).getNameFirstRep()));
        mutators.add((ctx, pract) -> ctx.fuzzChildTypes(pract.getClass(), pract.getCommunication(), () -> ((Practitioner)pract).getCommunicationFirstRep()));
        mutators.add((ctx, pract) -> ctx.fuzzChildTypes(pract.getClass(), pract.getPhoto(), () -> ((Practitioner)pract).getPhotoFirstRep()));
        mutators.add((ctx, pract) -> ctx.fuzzChildTypes(pract.getClass(), pract.getTelecom(), () -> ((Practitioner)pract).getTelecomFirstRep()));
        mutators.add((ctx, pract) -> {
            List qts = pract.getQualification();
            return ctx.randomness().chooseRandomly(qts).map(qt -> ctx.fuzzChild(pract.getClass(), qt.getCode())).orElseGet(() -> {
                Practitioner.PractitionerQualificationComponent qtComponent = new Practitioner.PractitionerQualificationComponent();
                qtComponent.getCode().setText(ctx.randomness().regexify("[a-zA-Z ]{10,20}"));
                qts.add(qtComponent);
                return FuzzingLogEntry.operation(MessageFormat.format("Add random PractitionerQualification with text ''{0}''", qtComponent.getCode().getText()));
            });
        });
        return mutators;
    }
}

