/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Person;

public class PersonMutatorProvider
extends BaseDomainResourceMutatorProvider<Person> {
    public PersonMutatorProvider() {
        super(PersonMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Person>> createMutators() {
        LinkedList<FuzzingMutator<Person>> mutators = new LinkedList<FuzzingMutator<Person>>();
        mutators.add((ctx, person) -> ctx.fuzzChildTypes(person.getClass(), person.getAddress(), () -> ((Person)person).getAddressFirstRep()));
        mutators.add((ctx, person) -> ctx.fuzzChildTypes(person.getClass(), person.getIdentifier(), () -> ((Person)person).getIdentifierFirstRep()));
        mutators.add((ctx, person) -> ctx.fuzzChildTypes(person.getClass(), person.getName(), () -> ((Person)person).getNameFirstRep()));
        mutators.add((ctx, person) -> ctx.fuzzChildTypes(person.getClass(), person.getTelecom(), () -> ((Person)person).getTelecomFirstRep()));
        mutators.add((ctx, person) -> ctx.fuzzChild(person, () -> ((Person)person).hasActive(), () -> ((Person)person).getActiveElement()));
        mutators.add((ctx, person) -> ctx.fuzzChild(person, () -> ((Person)person).hasPhoto(), () -> ((Person)person).getPhoto()));
        mutators.add((ctx, person) -> ctx.fuzzChild(person, () -> ((Person)person).hasManagingOrganization(), () -> ((Person)person).getManagingOrganization()));
        mutators.add((ctx, person) -> ctx.fuzzChild(person, () -> ((Person)person).hasBirthDate(), () -> ((Person)person).getBirthDateElement()));
        return mutators;
    }
}

