/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Patient;

public class PatientMutatorProvider
extends BaseDomainResourceMutatorProvider<Patient> {
    public PatientMutatorProvider() {
        super(PatientMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Patient>> createMutators() {
        LinkedList<FuzzingMutator<Patient>> mutators = new LinkedList<FuzzingMutator<Patient>>();
        mutators.add((ctx, pat) -> ctx.fuzzChildTypes(pat.getClass(), pat.getAddress(), () -> ((Patient)pat).getAddressFirstRep()));
        mutators.add((ctx, pat) -> ctx.fuzzChildTypes(pat.getClass(), pat.getIdentifier(), () -> ((Patient)pat).getIdentifierFirstRep()));
        mutators.add((ctx, pat) -> ctx.fuzzChildTypes(pat.getClass(), pat.getName(), () -> ((Patient)pat).getNameFirstRep()));
        mutators.add((ctx, pat) -> ctx.fuzzChildTypes(pat.getClass(), pat.getPhoto(), () -> ((Patient)pat).getPhotoFirstRep()));
        mutators.add((ctx, pat) -> ctx.fuzzChildTypes(pat.getClass(), pat.getTelecom(), () -> ((Patient)pat).getTelecomFirstRep()));
        return mutators;
    }
}

