/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseResourceMutatorProvider;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;

public class ParametersMutatorProvider
extends BaseResourceMutatorProvider<Parameters> {
    public ParametersMutatorProvider() {
        super(ParametersMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Parameters>> createMutators() {
        LinkedList<FuzzingMutator<Parameters>> mutators = new LinkedList<FuzzingMutator<Parameters>>();
        mutators.add((ctx, parameters) -> {
            parameters.setParameter(List.of());
            return FuzzingLogEntry.operation(MessageFormat.format("Remove parameters from {0}", parameters.getId()));
        });
        mutators.add((ctx, parameters) -> {
            LinkedList p = new LinkedList();
            int amount = ctx.randomness().source().nextInt(1, 20);
            IntStream.rangeClosed(0, amount).forEach(idx -> {
                StringType stc = new StringType(ctx.randomness().url());
                Parameters.ParametersParameterComponent ppc = new Parameters.ParametersParameterComponent(stc);
                ppc.setName(ctx.randomness().fhir().fhirResourceId());
                p.add(ppc);
            });
            parameters.setParameter(p);
            return FuzzingLogEntry.operation(MessageFormat.format("Create randomly {0} ParameterComponents for {1}", amount, parameters.getId()));
        });
        return mutators;
    }
}

