/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Type;

public class ObservationMutatorProvider
extends BaseDomainResourceMutatorProvider<Observation> {
    public ObservationMutatorProvider() {
        super(ObservationMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Observation>> createMutators() {
        LinkedList<FuzzingMutator<Observation>> mutators = new LinkedList<FuzzingMutator<Observation>>();
        mutators.add((ctx, ob) -> ctx.fuzzChildTypes(ob.getClass(), ob.getIdentifier(), () -> ((Observation)ob).getIdentifierFirstRep()));
        mutators.add((ctx, ob) -> ctx.fuzzChildTypes(ob.getClass(), ob.getBasedOn(), () -> ((Observation)ob).getBasedOnFirstRep()));
        mutators.add((ctx, ob) -> ctx.fuzzChildTypes(ob.getClass(), ob.getCategory(), () -> ((Observation)ob).getCategoryFirstRep()));
        mutators.add((ctx, ob) -> ctx.fuzzChildTypes(ob.getClass(), ob.getDerivedFrom(), () -> ((Observation)ob).getDerivedFromFirstRep()));
        mutators.add((ctx, ob) -> ctx.fuzzChildTypes(ob.getClass(), ob.getFocus(), () -> ((Observation)ob).getFocusFirstRep()));
        mutators.add((ctx, ob) -> ctx.fuzzChildTypes(ob.getClass(), ob.getHasMember(), () -> ((Observation)ob).getHasMemberFirstRep()));
        mutators.add((ctx, ob) -> ctx.fuzzChildTypes(ob.getClass(), ob.getInterpretation(), () -> ((Observation)ob).getInterpretationFirstRep()));
        mutators.add((ctx, ob) -> ctx.fuzzChildTypes(ob.getClass(), ob.getNote(), () -> ((Observation)ob).getNoteFirstRep()));
        mutators.add((ctx, ob) -> ctx.fuzzChildTypes(ob.getClass(), ob.getPartOf(), () -> ((Observation)ob).getPartOfFirstRep()));
        mutators.add((ctx, ob) -> ctx.fuzzChildTypes(ob.getClass(), ob.getPerformer(), () -> ((Observation)ob).getPerformerFirstRep()));
        mutators.add((ctx, ob) -> ctx.fuzzChild(ob, () -> ((Observation)ob).hasBodySite(), () -> ((Observation)ob).getBodySite()));
        mutators.add((ctx, ob) -> ctx.fuzzChild(ob, () -> ((Observation)ob).hasCode(), () -> ((Observation)ob).getCode()));
        mutators.add((ctx, ob) -> ctx.fuzzChild(ob, () -> ((Observation)ob).hasDataAbsentReason(), () -> ((Observation)ob).getDataAbsentReason()));
        mutators.add((ctx, ob) -> ctx.fuzzChild(ob, () -> ((Observation)ob).hasDevice(), () -> ((Observation)ob).getDevice()));
        mutators.add((ctx, ob) -> ctx.fuzzChild(ob, () -> ((Observation)ob).hasEncounter(), () -> ((Observation)ob).getEncounter()));
        mutators.add((ctx, ob) -> ctx.fuzzChild(ob, () -> ((Observation)ob).hasMethod(), () -> ((Observation)ob).getMethod()));
        mutators.add((ctx, ob) -> ctx.fuzzChild(ob, () -> ((Observation)ob).hasSpecimen(), () -> ((Observation)ob).getSpecimen()));
        mutators.add((ctx, ob) -> {
            if (ob.hasValue()) {
                return ctx.fuzzChild(ob, true, () -> ((Observation)ob).getValue());
            }
            Supplier[] supplierArray = new Supplier[11];
            supplierArray[0] = () -> ((Observation)ob).getValueBooleanType();
            supplierArray[1] = () -> ((Observation)ob).getValueRange();
            supplierArray[2] = () -> ((Observation)ob).getValueIntegerType();
            supplierArray[3] = () -> ((Observation)ob).getValueTimeType();
            supplierArray[4] = () -> ((Observation)ob).getValueStringType();
            supplierArray[5] = () -> ((Observation)ob).getValueDateTimeType();
            supplierArray[6] = () -> ((Observation)ob).getValueCodeableConcept();
            supplierArray[7] = () -> ((Observation)ob).getValuePeriod();
            supplierArray[8] = () -> ((Observation)ob).getValueQuantity();
            supplierArray[9] = () -> ((Observation)ob).getValueRatio();
            supplierArray[10] = () -> ((Observation)ob).getValueSampledData();
            Supplier supplier = ctx.randomness().chooseRandomElement(List.of(supplierArray));
            return ctx.fuzzChild(ob, false, supplier);
        });
        mutators.add((ctx, ob) -> {
            if (ob.hasEffective()) {
                return ctx.fuzzChild(ob, true, () -> ((Observation)ob).getEffective());
            }
            Supplier<Type> supplier = ctx.randomness().chooseRandomElement(List.of(() -> ((Observation)ob).getEffectiveInstantType(), () -> ((Observation)ob).getEffectivePeriod(), () -> ((Observation)ob).getEffectiveTiming(), () -> ((Observation)ob).getEffectiveDateTimeType()));
            return ctx.fuzzChild(ob, false, supplier);
        });
        return mutators;
    }
}

