/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.Type;

public class MedicationRequestMutatorProvider
extends BaseDomainResourceMutatorProvider<MedicationRequest> {
    public MedicationRequestMutatorProvider() {
        super(MedicationRequestMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<MedicationRequest>> createMutators() {
        LinkedList<FuzzingMutator<MedicationRequest>> mutators = new LinkedList<FuzzingMutator<MedicationRequest>>();
        mutators.add((ctx, mr) -> ctx.fuzzChildTypes(mr.getClass(), mr.getBasedOn(), () -> ((MedicationRequest)mr).getBasedOnFirstRep()));
        mutators.add((ctx, mr) -> ctx.fuzzChildTypes(mr.getClass(), mr.getCategory(), () -> ((MedicationRequest)mr).getCategoryFirstRep()));
        mutators.add((ctx, mr) -> ctx.fuzzChildTypes(mr.getClass(), mr.getIdentifier(), () -> ((MedicationRequest)mr).getIdentifierFirstRep()));
        mutators.add((ctx, mr) -> ctx.fuzzChildTypes(mr.getClass(), mr.getDetectedIssue(), () -> ((MedicationRequest)mr).getDetectedIssueFirstRep()));
        mutators.add((ctx, mr) -> ctx.fuzzChildTypes(mr.getClass(), mr.getDosageInstruction(), () -> ((MedicationRequest)mr).getDosageInstructionFirstRep()));
        mutators.add((ctx, mr) -> ctx.fuzzChildTypes(mr.getClass(), mr.getEventHistory(), () -> ((MedicationRequest)mr).getEventHistoryFirstRep()));
        mutators.add((ctx, mr) -> ctx.fuzzChildTypes(mr.getClass(), mr.getInstantiatesCanonical(), () -> ((MedicationRequest)mr).addInstantiatesCanonicalElement()));
        mutators.add((ctx, mr) -> ctx.fuzzChildTypes(mr.getClass(), mr.getInstantiatesUri(), () -> ((MedicationRequest)mr).addInstantiatesUriElement()));
        mutators.add((ctx, mr) -> ctx.fuzzChildTypes(mr.getClass(), mr.getInsurance(), () -> ((MedicationRequest)mr).getInsuranceFirstRep()));
        mutators.add((ctx, mr) -> ctx.fuzzChildTypes(mr.getClass(), mr.getNote(), () -> ((MedicationRequest)mr).getNoteFirstRep()));
        mutators.add((ctx, mr) -> ctx.fuzzChildTypes(mr.getClass(), mr.getReasonCode(), () -> ((MedicationRequest)mr).getReasonCodeFirstRep()));
        mutators.add((ctx, mr) -> ctx.fuzzChildTypes(mr.getClass(), mr.getReasonReference(), () -> ((MedicationRequest)mr).getReasonReferenceFirstRep()));
        mutators.add((ctx, mr) -> ctx.fuzzChildTypes(mr.getClass(), mr.getSupportingInformation(), () -> ((MedicationRequest)mr).getSupportingInformationFirstRep()));
        mutators.add((ctx, mr) -> ctx.fuzzChild(mr, () -> ((MedicationRequest)mr).hasPerformerType(), () -> ((MedicationRequest)mr).getPerformerType()));
        mutators.add((ctx, mr) -> ctx.fuzzChild(mr, () -> ((MedicationRequest)mr).hasPerformer(), () -> ((MedicationRequest)mr).getPerformer()));
        mutators.add((ctx, mr) -> ctx.fuzzChild(mr, () -> ((MedicationRequest)mr).hasRecorder(), () -> ((MedicationRequest)mr).getRecorder()));
        mutators.add((ctx, mr) -> ctx.fuzzChild(mr, () -> ((MedicationRequest)mr).hasAuthoredOn(), () -> ((MedicationRequest)mr).getAuthoredOnElement()));
        mutators.add((ctx, mr) -> ctx.fuzzChild(mr, () -> ((MedicationRequest)mr).hasDoNotPerform(), () -> ((MedicationRequest)mr).getDoNotPerformElement()));
        mutators.add((ctx, mr) -> ctx.fuzzChild(mr, () -> ((MedicationRequest)mr).hasEncounter(), () -> ((MedicationRequest)mr).getEncounter()));
        mutators.add((ctx, mr) -> ctx.fuzzChild(mr, () -> ((MedicationRequest)mr).hasGroupIdentifier(), () -> ((MedicationRequest)mr).getGroupIdentifier()));
        mutators.add((ctx, mr) -> ctx.fuzzChild(mr, () -> ((MedicationRequest)mr).hasIntent(), () -> ((MedicationRequest)mr).getIntentElement()));
        mutators.add((ctx, mr) -> ctx.fuzzChild(mr, () -> ((MedicationRequest)mr).hasPriority(), () -> ((MedicationRequest)mr).getPriorityElement()));
        mutators.add((ctx, mr) -> ctx.fuzzChild(mr, () -> ((MedicationRequest)mr).hasPriorPrescription(), () -> ((MedicationRequest)mr).getPriorPrescription()));
        mutators.add((ctx, mr) -> ctx.fuzzChild(mr, () -> ((MedicationRequest)mr).hasStatus(), () -> ((MedicationRequest)mr).getStatusElement()));
        mutators.add((ctx, mr) -> ctx.fuzzChild(mr, () -> ((MedicationRequest)mr).hasStatusReason(), () -> ((MedicationRequest)mr).getStatusReason()));
        mutators.add((ctx, mr) -> ctx.fuzzChild(mr, () -> ((MedicationRequest)mr).hasSubject(), () -> ((MedicationRequest)mr).getSubject()));
        mutators.add((ctx, mr) -> {
            if (mr.hasReported()) {
                return ctx.fuzzChild(mr, true, () -> ((MedicationRequest)mr).getReported());
            }
            Supplier<Type> supplier = ctx.randomness().chooseRandomElement(List.of(() -> ((MedicationRequest)mr).getReportedBooleanType(), () -> ((MedicationRequest)mr).getReportedReference()));
            return ctx.fuzzChild(mr, false, supplier);
        });
        mutators.add((ctx, mr) -> {
            if (mr.hasMedication()) {
                return ctx.fuzzChild(mr, true, () -> ((MedicationRequest)mr).getMedication());
            }
            Supplier<Type> supplier = ctx.randomness().chooseRandomElement(List.of(() -> ((MedicationRequest)mr).getMedicationReference(), () -> ((MedicationRequest)mr).getMedicationCodeableConcept()));
            return ctx.fuzzChild(mr, false, supplier);
        });
        mutators.add((ctx, medicationRequest) -> {
            List identifiers = ctx.randomness().childResourceDice().chooseRandomElements(medicationRequest.getIdentifier());
            if (identifiers.isEmpty()) {
                Randomness rnd = ctx.randomness();
                Identifier identifier = medicationRequest.addIdentifier();
                String system = rnd.url(rnd.chooseRandomFromEnum(ResourceType.class), rnd.uuid());
                identifier.setSystem(system);
                identifier.setValue(rnd.regexify(".{10,20}"));
                String message = MessageFormat.format("Add Random Identifier to MedicationRequest {0}: system={1} and value={2}", medicationRequest.getId(), identifier.getSystem(), identifier.getValue());
                return FuzzingLogEntry.operation(message);
            }
            return ctx.fuzzChildTypes(medicationRequest.getClass(), identifiers);
        });
        mutators.add((ctx, medicationRequest) -> {
            if (medicationRequest.getMedication() == null) {
                medicationRequest.setMedication((Type)new Reference(ctx.randomness().uuid()));
            }
            return ctx.fuzzChild(medicationRequest.getClass(), medicationRequest.getMedication());
        });
        return mutators;
    }
}

