/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.ResourceType;

public class MedicationMutatorProvider
extends BaseDomainResourceMutatorProvider<Medication> {
    public MedicationMutatorProvider() {
        super(MedicationMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Medication>> createMutators() {
        LinkedList<FuzzingMutator<Medication>> mutators = new LinkedList<FuzzingMutator<Medication>>();
        mutators.add((ctx, medication) -> ctx.fuzzChildTypes(medication.getClass(), medication.getIdentifier(), () -> ((Medication)medication).getIdentifierFirstRep()));
        mutators.add((ctx, medication) -> ctx.fuzzChild(medication, () -> ((Medication)medication).hasAmount(), () -> ((Medication)medication).getAmount()));
        mutators.add((ctx, medication) -> ctx.fuzzChild(medication, () -> ((Medication)medication).hasForm(), () -> ((Medication)medication).getForm()));
        mutators.add((ctx, medication) -> ctx.fuzzChild(medication, () -> ((Medication)medication).hasCode(), () -> ((Medication)medication).getCode()));
        mutators.add((ctx, medication) -> ctx.fuzzChild(medication, () -> ((Medication)medication).hasManufacturer(), () -> ((Medication)medication).getManufacturer()));
        mutators.add((ctx, medication) -> {
            Randomness rnd = ctx.randomness();
            List identifiers = rnd.childResourceDice().chooseRandomElements(medication.getIdentifier());
            if (identifiers.isEmpty()) {
                Identifier identifier = medication.addIdentifier();
                String system = rnd.url(rnd.chooseRandomFromEnum(ResourceType.class), rnd.uuid());
                identifier.setSystem(system);
                identifier.setValue(rnd.regexify(".{10,20}"));
                String message = MessageFormat.format("Add Random Identifier to Medication {0}: system={1} and value={2}", medication.getId(), identifier.getSystem(), identifier.getValue());
                return FuzzingLogEntry.operation(message);
            }
            return ctx.fuzzChildTypes(medication.getClass(), identifiers);
        });
        return mutators;
    }
}

