/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Type;

public class MedicationDispenseMutatorProvider
extends BaseDomainResourceMutatorProvider<MedicationDispense> {
    public MedicationDispenseMutatorProvider() {
        super(MedicationDispenseMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<MedicationDispense>> createMutators() {
        LinkedList<FuzzingMutator<MedicationDispense>> mutators = new LinkedList<FuzzingMutator<MedicationDispense>>();
        mutators.add((ctx, md) -> ctx.fuzzChildTypes(md.getClass(), md.getAuthorizingPrescription(), () -> ((MedicationDispense)md).getAuthorizingPrescriptionFirstRep()));
        mutators.add((ctx, md) -> ctx.fuzzChildTypes(md.getClass(), md.getDetectedIssue(), () -> ((MedicationDispense)md).getDetectedIssueFirstRep()));
        mutators.add((ctx, md) -> ctx.fuzzChildTypes(md.getClass(), md.getDosageInstruction(), () -> ((MedicationDispense)md).getDosageInstructionFirstRep()));
        mutators.add((ctx, md) -> ctx.fuzzChildTypes(md.getClass(), md.getEventHistory(), () -> ((MedicationDispense)md).getEventHistoryFirstRep()));
        mutators.add((ctx, md) -> ctx.fuzzChildTypes(md.getClass(), md.getIdentifier(), () -> ((MedicationDispense)md).getIdentifierFirstRep()));
        mutators.add((ctx, md) -> ctx.fuzzChildTypes(md.getClass(), md.getPartOf(), () -> ((MedicationDispense)md).getPartOfFirstRep()));
        mutators.add((ctx, md) -> ctx.fuzzChildTypes(md.getClass(), md.getReceiver(), () -> ((MedicationDispense)md).getReceiverFirstRep()));
        mutators.add((ctx, md) -> ctx.fuzzChildTypes(md.getClass(), md.getNote(), () -> ((MedicationDispense)md).getNoteFirstRep()));
        mutators.add((ctx, md) -> ctx.fuzzChildTypes(md.getClass(), md.getSupportingInformation(), () -> ((MedicationDispense)md).getSupportingInformationFirstRep()));
        mutators.add((ctx, md) -> ctx.fuzzChild(md, () -> ((MedicationDispense)md).hasType(), () -> ((MedicationDispense)md).getType()));
        mutators.add((ctx, md) -> ctx.fuzzChild(md, () -> ((MedicationDispense)md).hasCategory(), () -> ((MedicationDispense)md).getCategory()));
        mutators.add((ctx, md) -> ctx.fuzzChild(md, () -> ((MedicationDispense)md).hasContext(), () -> ((MedicationDispense)md).getContext()));
        mutators.add((ctx, md) -> ctx.fuzzChild(md, () -> ((MedicationDispense)md).hasDaysSupply(), () -> ((MedicationDispense)md).getDaysSupply()));
        mutators.add((ctx, md) -> ctx.fuzzChild(md, () -> ((MedicationDispense)md).hasDestination(), () -> ((MedicationDispense)md).getDestination()));
        mutators.add((ctx, md) -> ctx.fuzzChild(md, () -> ((MedicationDispense)md).hasLocation(), () -> ((MedicationDispense)md).getLocation()));
        mutators.add((ctx, md) -> ctx.fuzzChild(md, () -> ((MedicationDispense)md).hasQuantity(), () -> ((MedicationDispense)md).getQuantity()));
        mutators.add((ctx, md) -> ctx.fuzzChild(md, () -> ((MedicationDispense)md).hasSubject(), () -> ((MedicationDispense)md).getSubject()));
        mutators.add((ctx, md) -> ctx.fuzzChild(md, () -> ((MedicationDispense)md).hasWhenHandedOver(), () -> ((MedicationDispense)md).getWhenHandedOverElement()));
        mutators.add((ctx, md) -> ctx.fuzzChild(md, () -> ((MedicationDispense)md).hasWhenPrepared(), () -> ((MedicationDispense)md).getWhenPreparedElement()));
        mutators.add((ctx, md) -> {
            if (md.getMedication() == null) {
                md.setMedication((Type)new Reference(ctx.randomness().uuid()));
            }
            return ctx.fuzzChild(md.getClass(), md.getMedication());
        });
        mutators.add((ctx, md) -> {
            if (md.hasStatusReason()) {
                return ctx.fuzzChild(md, true, () -> ((MedicationDispense)md).getStatusReason());
            }
            Supplier<Type> supplier = ctx.randomness().chooseRandomElement(List.of(() -> ((MedicationDispense)md).getStatusReasonReference(), () -> ((MedicationDispense)md).getStatusReasonCodeableConcept()));
            return ctx.fuzzChild(md, false, supplier);
        });
        mutators.add((ctx, md) -> {
            MedicationDispense.MedicationDispenseStatus original = md.getStatus();
            MedicationDispense.MedicationDispenseStatus status = ctx.randomness().chooseRandomFromEnum(MedicationDispense.MedicationDispenseStatus.class, original);
            md.setStatus(status);
            return FuzzingLogEntry.operation(MessageFormat.format("Change Status of MedicationDispense {0}: {1} -> {2}", md.getId(), original, status));
        });
        return mutators;
    }
}

