/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.hl7.fhir.r4.model.Media;
import org.hl7.fhir.r4.model.Type;

public class MediaMutatorProvider
extends BaseDomainResourceMutatorProvider<Media> {
    public MediaMutatorProvider() {
        super(MediaMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Media>> createMutators() {
        LinkedList<FuzzingMutator<Media>> mutators = new LinkedList<FuzzingMutator<Media>>();
        mutators.add((ctx, media) -> ctx.fuzzChildTypes(media.getClass(), media.getIdentifier(), () -> ((Media)media).getIdentifierFirstRep()));
        mutators.add((ctx, media) -> ctx.fuzzChildTypes(media.getClass(), media.getNote(), () -> ((Media)media).getNoteFirstRep()));
        mutators.add((ctx, media) -> ctx.fuzzChildTypes(media.getClass(), media.getPartOf(), () -> ((Media)media).getPartOfFirstRep()));
        mutators.add((ctx, media) -> ctx.fuzzChildTypes(media.getClass(), media.getBasedOn(), () -> ((Media)media).getBasedOnFirstRep()));
        mutators.add((ctx, media) -> ctx.fuzzChildTypes(media.getClass(), media.getReasonCode(), () -> ((Media)media).getReasonCodeFirstRep()));
        mutators.add((ctx, media) -> ctx.fuzzChild(media, () -> ((Media)media).hasDuration(), () -> ((Media)media).getDurationElement()));
        mutators.add((ctx, media) -> ctx.fuzzChild(media, () -> ((Media)media).hasEncounter(), () -> ((Media)media).getEncounter()));
        mutators.add((ctx, media) -> ctx.fuzzChild(media, () -> ((Media)media).hasType(), () -> ((Media)media).getType()));
        mutators.add((ctx, media) -> ctx.fuzzChild(media, () -> ((Media)media).hasModality(), () -> ((Media)media).getModality()));
        mutators.add((ctx, media) -> ctx.fuzzChild(media, () -> ((Media)media).hasFrames(), () -> ((Media)media).getFramesElement()));
        mutators.add((ctx, media) -> ctx.fuzzChild(media, () -> ((Media)media).hasHeight(), () -> ((Media)media).getHeightElement()));
        mutators.add((ctx, media) -> ctx.fuzzChild(media, () -> ((Media)media).hasWidth(), () -> ((Media)media).getWidthElement()));
        mutators.add((ctx, media) -> ctx.fuzzChild(media, () -> ((Media)media).hasIssued(), () -> ((Media)media).getIssuedElement()));
        mutators.add((ctx, media) -> ctx.fuzzChild(media, () -> ((Media)media).hasContent(), () -> ((Media)media).getContent()));
        mutators.add((ctx, media) -> ctx.fuzzChild(media, () -> ((Media)media).hasDevice(), () -> ((Media)media).getDevice()));
        mutators.add((ctx, media) -> ctx.fuzzChild(media, () -> ((Media)media).hasBodySite(), () -> ((Media)media).getBodySite()));
        mutators.add((ctx, media) -> {
            if (media.hasCreated()) {
                return ctx.fuzzChild(media, true, () -> ((Media)media).getCreated());
            }
            Supplier<Type> supplier = ctx.randomness().chooseRandomElement(List.of(() -> ((Media)media).getCreatedPeriod(), () -> ((Media)media).getCreatedDateTimeType()));
            return ctx.fuzzChild(media, false, supplier);
        });
        mutators.add((ctx, media) -> {
            Media.MediaStatus status = media.getStatus();
            Media.MediaStatus fstatus = ctx.randomness().chooseRandomFromEnum(Media.MediaStatus.class, status);
            return FuzzingLogEntry.operation(MessageFormat.format("Change MediaStatus of {0}: {1} -> {2}", media.getId(), status, fstatus));
        });
        return mutators;
    }
}

