/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Location;

public class LocationMutatorProvider
extends BaseDomainResourceMutatorProvider<Location> {
    public LocationMutatorProvider() {
        super(LocationMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Location>> createMutators() {
        LinkedList<FuzzingMutator<Location>> mutators = new LinkedList<FuzzingMutator<Location>>();
        mutators.add((ctx, location) -> ctx.fuzzChildTypes(location.getClass(), location.getEndpoint(), () -> ((Location)location).getEndpointFirstRep()));
        mutators.add((ctx, location) -> ctx.fuzzChildTypes(location.getClass(), location.getIdentifier(), () -> ((Location)location).getIdentifierFirstRep()));
        mutators.add((ctx, location) -> ctx.fuzzChildTypes(location.getClass(), location.getTelecom(), () -> ((Location)location).getTelecomFirstRep()));
        mutators.add((ctx, location) -> ctx.fuzzChildTypes(location.getClass(), location.getType(), () -> ((Location)location).getTypeFirstRep()));
        mutators.add((ctx, location) -> ctx.fuzzChild(location, () -> ((Location)location).hasAddress(), () -> ((Location)location).getAddress()));
        mutators.add((ctx, location) -> ctx.fuzzChild(location, () -> ((Location)location).hasDescription(), () -> ((Location)location).getDescriptionElement()));
        mutators.add((ctx, location) -> ctx.fuzzChild(location, () -> ((Location)location).hasName(), () -> ((Location)location).getNameElement()));
        mutators.add((ctx, location) -> ctx.fuzzChild(location, () -> ((Location)location).hasManagingOrganization(), () -> ((Location)location).getManagingOrganization()));
        mutators.add((ctx, location) -> ctx.fuzzChild(location, () -> ((Location)location).hasOperationalStatus(), () -> ((Location)location).getOperationalStatus()));
        mutators.add((ctx, location) -> ctx.fuzzChild(location, () -> ((Location)location).hasPartOf(), () -> ((Location)location).getPartOf()));
        mutators.add((ctx, location) -> ctx.fuzzChild(location, () -> ((Location)location).hasPhysicalType(), () -> ((Location)location).getPhysicalType()));
        return mutators;
    }
}

