/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveStringTypes;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeFuzzingResponse;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Invoice;

public class InvoiceMutatorProvider
extends BaseDomainResourceMutatorProvider<Invoice> {
    public InvoiceMutatorProvider() {
        super(InvoiceMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Invoice>> createMutators() {
        LinkedList<FuzzingMutator<Invoice>> mutators = new LinkedList<FuzzingMutator<Invoice>>();
        mutators.add((ctx, invoice) -> ctx.fuzzChildTypes(invoice.getClass(), invoice.getIdentifier(), () -> ((Invoice)invoice).getIdentifierFirstRep()));
        mutators.add((ctx, invoice) -> ctx.fuzzChildTypes(invoice.getClass(), invoice.getNote(), () -> ((Invoice)invoice).getNoteFirstRep()));
        mutators.add((ctx, invoice) -> ctx.fuzzChild(invoice, () -> ((Invoice)invoice).hasAccount(), () -> ((Invoice)invoice).getAccount()));
        mutators.add((ctx, invoice) -> ctx.fuzzChild(invoice, () -> ((Invoice)invoice).hasCancelledReason(), () -> ((Invoice)invoice).getCancelledReasonElement()));
        mutators.add((ctx, invoice) -> ctx.fuzzChild(invoice, () -> ((Invoice)invoice).hasDate(), () -> ((Invoice)invoice).getDateElement()));
        mutators.add((ctx, invoice) -> ctx.fuzzChild(invoice, () -> ((Invoice)invoice).hasIssuer(), () -> ((Invoice)invoice).getIssuer()));
        mutators.add((ctx, invoice) -> ctx.fuzzChild(invoice, () -> ((Invoice)invoice).hasRecipient(), () -> ((Invoice)invoice).getRecipient()));
        mutators.add((ctx, invoice) -> ctx.fuzzChild(invoice, () -> ((Invoice)invoice).hasSubject(), () -> ((Invoice)invoice).getSubject()));
        mutators.add((ctx, invoice) -> ctx.fuzzChild(invoice, () -> ((Invoice)invoice).hasTotalGross(), () -> ((Invoice)invoice).getTotalGross()));
        mutators.add((ctx, invoice) -> ctx.fuzzChild(invoice, () -> ((Invoice)invoice).hasTotalNet(), () -> ((Invoice)invoice).getTotalNet()));
        mutators.add((ctx, invoice) -> ctx.fuzzChild(invoice, () -> ((Invoice)invoice).hasType(), () -> ((Invoice)invoice).getType()));
        mutators.add((ctx, invoice) -> {
            PrimitiveTypeFuzzingResponse<String> response = ctx.fuzzPrimitiveType(MessageFormat.format("Fuzz PaymentTerms of Invoice {0}", invoice.getId()), PrimitiveStringTypes.TEXT, invoice.getPaymentTerms());
            invoice.setPaymentTerms(response.getFuzzedValue());
            return response.getLogEntry();
        });
        mutators.add((ctx, invoice) -> {
            List otpc = invoice.getTotalPriceComponent();
            List<FuzzingLogEntry> children = ctx.randomness().childResourceDice().chooseRandomElements(otpc).stream().map(ilipcc -> ctx.fuzzChild(invoice.getClass(), ilipcc.getCode())).toList();
            return FuzzingLogEntry.parent(MessageFormat.format("Fuzz TotalPriceComponents of Invoice {0}", invoice.getId()), children);
        });
        return mutators;
    }
}

