/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.hl7.fhir.r4.model.Goal;
import org.hl7.fhir.r4.model.Type;

public class GoalMutatorProvider
extends BaseDomainResourceMutatorProvider<Goal> {
    public GoalMutatorProvider() {
        super(GoalMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Goal>> createMutators() {
        LinkedList<FuzzingMutator<Goal>> mutators = new LinkedList<FuzzingMutator<Goal>>();
        mutators.add((ctx, goal) -> ctx.fuzzChildTypes(goal.getClass(), goal.getAddresses(), () -> ((Goal)goal).getAddressesFirstRep()));
        mutators.add((ctx, goal) -> ctx.fuzzChildTypes(goal.getClass(), goal.getCategory(), () -> ((Goal)goal).getCategoryFirstRep()));
        mutators.add((ctx, goal) -> ctx.fuzzChildTypes(goal.getClass(), goal.getIdentifier(), () -> ((Goal)goal).getIdentifierFirstRep()));
        mutators.add((ctx, goal) -> ctx.fuzzChildTypes(goal.getClass(), goal.getNote(), () -> ((Goal)goal).getNoteFirstRep()));
        mutators.add((ctx, goal) -> ctx.fuzzChildTypes(goal.getClass(), goal.getOutcomeCode(), () -> ((Goal)goal).getOutcomeCodeFirstRep()));
        mutators.add((ctx, goal) -> ctx.fuzzChild(goal, () -> ((Goal)goal).hasSubject(), () -> ((Goal)goal).getSubject()));
        mutators.add((ctx, goal) -> ctx.fuzzChild(goal, () -> ((Goal)goal).hasAchievementStatus(), () -> ((Goal)goal).getAchievementStatus()));
        mutators.add((ctx, goal) -> ctx.fuzzChild(goal, () -> ((Goal)goal).hasDescription(), () -> ((Goal)goal).getDescription()));
        mutators.add((ctx, goal) -> ctx.fuzzChild(goal, () -> ((Goal)goal).hasExpressedBy(), () -> ((Goal)goal).getExpressedBy()));
        mutators.add((ctx, goal) -> ctx.fuzzChild(goal, () -> ((Goal)goal).hasPriority(), () -> ((Goal)goal).getPriority()));
        mutators.add((ctx, goal) -> {
            if (goal.hasStart()) {
                return ctx.fuzzChild(goal, true, () -> ((Goal)goal).getStart());
            }
            Supplier<Type> supplier = ctx.randomness().chooseRandomElement(List.of(() -> ((Goal)goal).getStartDateType(), () -> ((Goal)goal).getStartCodeableConcept()));
            return ctx.fuzzChild(goal.getClass(), () -> ((Goal)goal).hasStart(), supplier);
        });
        mutators.add((ctx, goal) -> {
            Goal.GoalLifecycleStatus status = goal.getLifecycleStatus();
            Goal.GoalLifecycleStatus fstatus = ctx.randomness().chooseRandomFromEnum(Goal.GoalLifecycleStatus.class, status);
            goal.setLifecycleStatus(fstatus);
            return FuzzingLogEntry.operation(MessageFormat.format("Change LifeCycleStatus of {0}: {1} -> {2}", goal.getId(), status, fstatus));
        });
        return mutators;
    }
}

