/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Encounter;

public class EncounterMutatorProvider
extends BaseDomainResourceMutatorProvider<Encounter> {
    public EncounterMutatorProvider() {
        super(EncounterMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Encounter>> createMutators() {
        LinkedList<FuzzingMutator<Encounter>> mutators = new LinkedList<FuzzingMutator<Encounter>>();
        mutators.add((ctx, encounter) -> ctx.fuzzChildTypes(encounter.getClass(), encounter.getIdentifier(), () -> ((Encounter)encounter).getIdentifierFirstRep()));
        mutators.add((ctx, encounter) -> ctx.fuzzChildTypes(encounter.getClass(), encounter.getType(), () -> ((Encounter)encounter).getTypeFirstRep()));
        mutators.add((ctx, encounter) -> ctx.fuzzChildTypes(encounter.getClass(), encounter.getAccount(), () -> ((Encounter)encounter).getAccountFirstRep()));
        mutators.add((ctx, encounter) -> ctx.fuzzChildTypes(encounter.getClass(), encounter.getAppointment(), () -> ((Encounter)encounter).getAppointmentFirstRep()));
        mutators.add((ctx, encounter) -> ctx.fuzzChildTypes(encounter.getClass(), encounter.getBasedOn(), () -> ((Encounter)encounter).getBasedOnFirstRep()));
        mutators.add((ctx, encounter) -> ctx.fuzzChildTypes(encounter.getClass(), encounter.getEpisodeOfCare(), () -> ((Encounter)encounter).getEpisodeOfCareFirstRep()));
        mutators.add((ctx, encounter) -> ctx.fuzzChildTypes(encounter.getClass(), encounter.getReasonCode(), () -> ((Encounter)encounter).getReasonCodeFirstRep()));
        mutators.add((ctx, encounter) -> ctx.fuzzChildTypes(encounter.getClass(), encounter.getReasonReference(), () -> ((Encounter)encounter).getReasonReferenceFirstRep()));
        mutators.add((ctx, encounter) -> ctx.fuzzChild(encounter, () -> ((Encounter)encounter).hasServiceType(), () -> ((Encounter)encounter).getServiceType()));
        mutators.add((ctx, encounter) -> ctx.fuzzChild(encounter, () -> ((Encounter)encounter).hasLength(), () -> ((Encounter)encounter).getLength()));
        mutators.add((ctx, encounter) -> ctx.fuzzChild(encounter, () -> ((Encounter)encounter).hasPartOf(), () -> ((Encounter)encounter).getPartOf()));
        mutators.add((ctx, encounter) -> ctx.fuzzChild(encounter, () -> ((Encounter)encounter).hasPriority(), () -> ((Encounter)encounter).getPriority()));
        mutators.add((ctx, encounter) -> ctx.fuzzChild(encounter, () -> ((Encounter)encounter).hasServiceProvider(), () -> ((Encounter)encounter).getServiceProvider()));
        mutators.add((ctx, encounter) -> ctx.fuzzChild(encounter, () -> ((Encounter)encounter).hasSubject(), () -> ((Encounter)encounter).getSubject()));
        return mutators;
    }
}

