/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.DocumentReference;

public class DocumentReferenceMutatorProvider
extends BaseDomainResourceMutatorProvider<DocumentReference> {
    public DocumentReferenceMutatorProvider() {
        super(DocumentReferenceMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<DocumentReference>> createMutators() {
        LinkedList<FuzzingMutator<DocumentReference>> mutators = new LinkedList<FuzzingMutator<DocumentReference>>();
        mutators.add((ctx, dr) -> ctx.fuzzChildTypes(dr.getClass(), dr.getIdentifier(), () -> ((DocumentReference)dr).getIdentifierFirstRep()));
        mutators.add((ctx, dr) -> ctx.fuzzChildTypes(dr.getClass(), dr.getAuthor(), () -> ((DocumentReference)dr).getAuthorFirstRep()));
        mutators.add((ctx, dr) -> ctx.fuzzChild(dr, () -> ((DocumentReference)dr).hasType(), () -> ((DocumentReference)dr).getType()));
        mutators.add((ctx, dr) -> ctx.fuzzChild(dr, () -> ((DocumentReference)dr).hasDate(), () -> ((DocumentReference)dr).getDateElement()));
        mutators.add((ctx, dr) -> ctx.fuzzChild(dr, () -> ((DocumentReference)dr).hasDescription(), () -> ((DocumentReference)dr).getDescriptionElement()));
        mutators.add((ctx, dr) -> ctx.fuzzChild(dr, () -> ((DocumentReference)dr).hasCustodian(), () -> ((DocumentReference)dr).getCustodian()));
        mutators.add((ctx, dr) -> ctx.fuzzChild(dr, () -> ((DocumentReference)dr).hasAuthenticator(), () -> ((DocumentReference)dr).getAuthenticator()));
        return mutators;
    }
}

