/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Device;

public class DeviceMutatorProvider
extends BaseDomainResourceMutatorProvider<Device> {
    public DeviceMutatorProvider() {
        super(DeviceMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Device>> createMutators() {
        LinkedList<FuzzingMutator<Device>> mutators = new LinkedList<FuzzingMutator<Device>>();
        mutators.add((ctx, device) -> ctx.fuzzChildTypes(device.getClass(), device.getContact(), () -> ((Device)device).getContactFirstRep()));
        mutators.add((ctx, device) -> ctx.fuzzChildTypes(device.getClass(), device.getIdentifier(), () -> ((Device)device).getIdentifierFirstRep()));
        mutators.add((ctx, device) -> ctx.fuzzChildTypes(device.getClass(), device.getNote(), () -> ((Device)device).getNoteFirstRep()));
        mutators.add((ctx, device) -> ctx.fuzzChild(device, () -> ((Device)device).hasDefinition(), () -> ((Device)device).getDefinition()));
        mutators.add((ctx, device) -> ctx.fuzzChild(device, () -> ((Device)device).hasDistinctIdentifier(), () -> ((Device)device).getDistinctIdentifierElement()));
        mutators.add((ctx, device) -> ctx.fuzzChild(device, () -> ((Device)device).hasExpirationDate(), () -> ((Device)device).getExpirationDateElement()));
        mutators.add((ctx, device) -> ctx.fuzzChild(device, () -> ((Device)device).hasLocation(), () -> ((Device)device).getLocation()));
        mutators.add((ctx, device) -> ctx.fuzzChild(device, () -> ((Device)device).hasLotNumber(), () -> ((Device)device).getLotNumberElement()));
        mutators.add((ctx, device) -> ctx.fuzzChild(device, () -> ((Device)device).hasManufactureDate(), () -> ((Device)device).getManufactureDateElement()));
        mutators.add((ctx, device) -> ctx.fuzzChild(device, () -> ((Device)device).hasManufacturer(), () -> ((Device)device).getManufacturerElement()));
        mutators.add((ctx, device) -> ctx.fuzzChild(device, () -> ((Device)device).hasModelNumber(), () -> ((Device)device).getModelNumberElement()));
        mutators.add((ctx, device) -> ctx.fuzzChild(device, () -> ((Device)device).hasOwner(), () -> ((Device)device).getOwner()));
        mutators.add((ctx, device) -> ctx.fuzzChild(device, () -> ((Device)device).hasParent(), () -> ((Device)device).getParent()));
        mutators.add((ctx, device) -> ctx.fuzzChild(device, () -> ((Device)device).hasPartNumber(), () -> ((Device)device).getPartNumberElement()));
        mutators.add((ctx, device) -> ctx.fuzzChild(device, () -> ((Device)device).hasPatient(), () -> ((Device)device).getPatient()));
        mutators.add((ctx, device) -> ctx.fuzzChild(device, () -> ((Device)device).hasType(), () -> ((Device)device).getType()));
        return mutators;
    }
}

