/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.hl7.fhir.r4.model.Type;

public class DetectedIssueMutatorProvider
extends BaseDomainResourceMutatorProvider<DetectedIssue> {
    public DetectedIssueMutatorProvider() {
        super(DetectedIssueMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<DetectedIssue>> createMutators() {
        LinkedList<FuzzingMutator<DetectedIssue>> mutators = new LinkedList<FuzzingMutator<DetectedIssue>>();
        mutators.add((ctx, di) -> ctx.fuzzChildTypes(di.getClass(), di.getIdentifier(), () -> ((DetectedIssue)di).getIdentifierFirstRep()));
        mutators.add((ctx, di) -> ctx.fuzzChildTypes(di.getClass(), di.getImplicated(), () -> ((DetectedIssue)di).getImplicatedFirstRep()));
        mutators.add((ctx, di) -> ctx.fuzzChild(di, () -> ((DetectedIssue)di).hasAuthor(), () -> ((DetectedIssue)di).getAuthor()));
        mutators.add((ctx, di) -> ctx.fuzzChild(di, () -> ((DetectedIssue)di).hasCode(), () -> ((DetectedIssue)di).getCode()));
        mutators.add((ctx, di) -> ctx.fuzzChild(di, () -> ((DetectedIssue)di).hasDetail(), () -> ((DetectedIssue)di).getDetailElement()));
        mutators.add((ctx, di) -> ctx.fuzzChild(di, () -> ((DetectedIssue)di).hasPatient(), () -> ((DetectedIssue)di).getPatient()));
        mutators.add((ctx, di) -> ctx.fuzzChild(di, () -> ((DetectedIssue)di).hasReference(), () -> ((DetectedIssue)di).getReferenceElement()));
        mutators.add((ctx, di) -> {
            if (di.hasIdentified()) {
                return ctx.fuzzChild(di, true, () -> ((DetectedIssue)di).getIdentified());
            }
            Supplier<Type> supplier = ctx.randomness().chooseRandomElement(List.of(() -> ((DetectedIssue)di).getIdentifiedPeriod(), () -> ((DetectedIssue)di).getIdentifiedDateTimeType()));
            return ctx.fuzzChild(di, false, supplier);
        });
        return mutators;
    }
}

