/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.hl7.fhir.r4.model.Contract;
import org.hl7.fhir.r4.model.Type;

public class ContractMutatorProvider
extends BaseDomainResourceMutatorProvider<Contract> {
    public ContractMutatorProvider() {
        super(ContractMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Contract>> createMutators() {
        LinkedList<FuzzingMutator<Contract>> mutators = new LinkedList<FuzzingMutator<Contract>>();
        mutators.add((ctx, ip) -> ctx.fuzzChildTypes(ip.getClass(), ip.getIdentifier(), () -> ((Contract)ip).getIdentifierFirstRep()));
        mutators.add((ctx, ip) -> ctx.fuzzChildTypes(ip.getClass(), ip.getAlias(), () -> ((Contract)ip).addAliasElement()));
        mutators.add((ctx, ip) -> ctx.fuzzChildTypes(ip.getClass(), ip.getSubType(), () -> ((Contract)ip).getSubTypeFirstRep()));
        mutators.add((ctx, ip) -> ctx.fuzzChildTypes(ip.getClass(), ip.getAuthority(), () -> ((Contract)ip).getAuthorityFirstRep()));
        mutators.add((ctx, ip) -> ctx.fuzzChildTypes(ip.getClass(), ip.getDomain(), () -> ((Contract)ip).getDomainFirstRep()));
        mutators.add((ctx, ip) -> ctx.fuzzChildTypes(ip.getClass(), ip.getRelevantHistory(), () -> ((Contract)ip).getRelevantHistoryFirstRep()));
        mutators.add((ctx, ip) -> ctx.fuzzChildTypes(ip.getClass(), ip.getSite(), () -> ((Contract)ip).getSiteFirstRep()));
        mutators.add((ctx, ip) -> ctx.fuzzChild(ip, () -> ((Contract)ip).hasType(), () -> ((Contract)ip).getType()));
        mutators.add((ctx, ip) -> ctx.fuzzChild(ip, () -> ((Contract)ip).hasName(), () -> ((Contract)ip).getNameElement()));
        mutators.add((ctx, ip) -> ctx.fuzzChild(ip, () -> ((Contract)ip).hasExpirationType(), () -> ((Contract)ip).getExpirationType()));
        mutators.add((ctx, ip) -> ctx.fuzzChild(ip, () -> ((Contract)ip).hasApplies(), () -> ((Contract)ip).getApplies()));
        mutators.add((ctx, ip) -> ctx.fuzzChild(ip, () -> ((Contract)ip).hasAuthor(), () -> ((Contract)ip).getAuthor()));
        mutators.add((ctx, ip) -> ctx.fuzzChild(ip, () -> ((Contract)ip).hasContentDerivative(), () -> ((Contract)ip).getContentDerivative()));
        mutators.add((ctx, ip) -> ctx.fuzzChild(ip, () -> ((Contract)ip).hasInstantiatesUri(), () -> ((Contract)ip).getInstantiatesUriElement()));
        mutators.add((ctx, ip) -> ctx.fuzzChild(ip, () -> ((Contract)ip).hasInstantiatesCanonical(), () -> ((Contract)ip).getInstantiatesCanonical()));
        mutators.add((ctx, ip) -> ctx.fuzzChild(ip, () -> ((Contract)ip).hasIssued(), () -> ((Contract)ip).getIssuedElement()));
        mutators.add((ctx, ip) -> ctx.fuzzChild(ip, () -> ((Contract)ip).hasLegalState(), () -> ((Contract)ip).getLegalState()));
        mutators.add((ctx, ip) -> ctx.fuzzChild(ip, () -> ((Contract)ip).hasScope(), () -> ((Contract)ip).getScope()));
        mutators.add((ctx, ip) -> {
            if (ip.hasLegallyBinding()) {
                return ctx.fuzzChild(ip, true, () -> ((Contract)ip).getLegallyBinding());
            }
            Supplier<Type> supplier = ctx.randomness().chooseRandomElement(List.of(() -> ((Contract)ip).getLegallyBindingAttachment(), () -> ((Contract)ip).getLegallyBindingReference()));
            return ctx.fuzzChild(ip, false, supplier);
        });
        return mutators;
    }
}

