/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FhirType;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Consent;
import org.hl7.fhir.r4.model.Type;

public class ConsentMutatorProvider
extends BaseDomainResourceMutatorProvider<Consent> {
    public ConsentMutatorProvider() {
        super(ConsentMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Consent>> createMutators() {
        LinkedList<FuzzingMutator<Consent>> mutators = new LinkedList<FuzzingMutator<Consent>>();
        mutators.add((ctx, consent) -> ctx.fuzzChildTypes(consent.getClass(), consent.getIdentifier(), () -> ((Consent)consent).getIdentifierFirstRep()));
        mutators.add((ctx, consent) -> ctx.fuzzChildTypes(consent.getClass(), consent.getCategory(), () -> ((Consent)consent).getCategoryFirstRep()));
        mutators.add((ctx, consent) -> ctx.fuzzChildTypes(consent.getClass(), consent.getOrganization(), () -> ((Consent)consent).getOrganizationFirstRep()));
        mutators.add((ctx, consent) -> ctx.fuzzChildTypes(consent.getClass(), consent.getPerformer(), () -> ((Consent)consent).getPerformerFirstRep()));
        mutators.add((ctx, consent) -> ctx.fuzzChild(consent, () -> ((Consent)consent).hasPatient(), () -> ((Consent)consent).getPatient()));
        mutators.add((ctx, consent) -> ctx.fuzzChild(consent, () -> ((Consent)consent).hasDateTimeElement(), () -> ((Consent)consent).getDateTimeElement()));
        mutators.add((ctx, consent) -> ctx.fuzzChild(consent, () -> ((Consent)consent).hasPolicyRule(), () -> ((Consent)consent).getPolicyRule()));
        mutators.add((ctx, consent) -> ctx.fuzzChild(consent, () -> ((Consent)consent).hasScope(), () -> ((Consent)consent).getScope()));
        mutators.add((ctx, consent) -> {
            if (!consent.hasSource()) {
                FhirType sourceType = ctx.randomness().chooseRandomElement(List.of(FhirType.ATTACHMENT, FhirType.REFERENCE));
                Type source = ctx.randomness().fhir().createType(sourceType);
                consent.setSource(source);
            }
            return ctx.fuzzChild(consent.getClass(), consent.getSource());
        });
        mutators.add((ctx, consent) -> ctx.randomness().chooseRandomly(consent.getPolicy()).map(p -> ctx.fuzzChild(consent.getClass(), p.getAuthorityElement())).orElseGet(() -> FuzzingLogEntry.noop(MessageFormat.format("Consent {0} does not have a policy to fuzz", consent.getId()))));
        mutators.add((ctx, consent) -> {
            Consent.ConsentState status = consent.getStatus();
            Consent.ConsentState fstatus = ctx.randomness().chooseRandomFromEnum(Consent.ConsentState.class, status);
            consent.setStatus(fstatus);
            return FuzzingLogEntry.operation(MessageFormat.format("Change Status of Consent {0}: {1} -> {2}", consent.getId(), status, fstatus));
        });
        return mutators;
    }
}

