/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Type;

public class ConditionMutatorProvider
extends BaseDomainResourceMutatorProvider<Condition> {
    public ConditionMutatorProvider() {
        super(ConditionMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Condition>> createMutators() {
        LinkedList<FuzzingMutator<Condition>> mutators = new LinkedList<FuzzingMutator<Condition>>();
        mutators.add((ctx, condition) -> ctx.fuzzChildTypes(condition.getClass(), condition.getCategory(), () -> ((Condition)condition).getCategoryFirstRep()));
        mutators.add((ctx, condition) -> ctx.fuzzChildTypes(condition.getClass(), condition.getBodySite(), () -> ((Condition)condition).getBodySiteFirstRep()));
        mutators.add((ctx, condition) -> ctx.fuzzChildTypes(condition.getClass(), condition.getIdentifier(), () -> ((Condition)condition).getIdentifierFirstRep()));
        mutators.add((ctx, condition) -> ctx.fuzzChildTypes(condition.getClass(), condition.getNote(), () -> ((Condition)condition).getNoteFirstRep()));
        mutators.add((ctx, condition) -> ctx.fuzzChild(condition, () -> ((Condition)condition).hasSubject(), () -> ((Condition)condition).getSubject()));
        mutators.add((ctx, condition) -> ctx.fuzzChild(condition, () -> ((Condition)condition).hasClinicalStatus(), () -> ((Condition)condition).getClinicalStatus()));
        mutators.add((ctx, condition) -> ctx.fuzzChild(condition, () -> ((Condition)condition).hasCode(), () -> ((Condition)condition).getCode()));
        mutators.add((ctx, condition) -> ctx.fuzzChild(condition, () -> ((Condition)condition).hasEncounter(), () -> ((Condition)condition).getEncounter()));
        mutators.add((ctx, condition) -> ctx.fuzzChild(condition, () -> ((Condition)condition).hasRecordedDate(), () -> ((Condition)condition).getRecordedDateElement()));
        mutators.add((ctx, condition) -> ctx.fuzzChild(condition, () -> ((Condition)condition).hasRecorder(), () -> ((Condition)condition).getRecorder()));
        mutators.add((ctx, condition) -> ctx.fuzzChild(condition, () -> ((Condition)condition).hasSeverity(), () -> ((Condition)condition).getSeverity()));
        mutators.add((ctx, condition) -> ctx.fuzzChild(condition, () -> ((Condition)condition).hasSubject(), () -> ((Condition)condition).getSubject()));
        mutators.add((ctx, condition) -> ctx.fuzzChild(condition, () -> ((Condition)condition).hasVerificationStatus(), () -> ((Condition)condition).getVerificationStatus()));
        mutators.add((ctx, condition) -> ctx.fuzzChild(condition, () -> ((Condition)condition).hasAsserter(), () -> ((Condition)condition).getAsserter()));
        mutators.add((ctx, condition) -> {
            if (condition.hasAbatement()) {
                return ctx.fuzzChild(condition, true, () -> ((Condition)condition).getAbatement());
            }
            Supplier<Type> supplier = ctx.randomness().chooseRandomElement(List.of(() -> ((Condition)condition).getAbatementAge(), () -> ((Condition)condition).getAbatementPeriod(), () -> ((Condition)condition).getAbatementRange(), () -> ((Condition)condition).getAbatementDateTimeType(), () -> ((Condition)condition).getAbatementStringType()));
            return ctx.fuzzChild(condition, false, supplier);
        });
        mutators.add((ctx, condition) -> {
            if (condition.hasOnset()) {
                return ctx.fuzzChild(condition, true, () -> ((Condition)condition).getOnset());
            }
            Supplier<Type> supplier = ctx.randomness().chooseRandomElement(List.of(() -> ((Condition)condition).getOnsetAge(), () -> ((Condition)condition).getOnsetPeriod(), () -> ((Condition)condition).getOnsetRange(), () -> ((Condition)condition).getOnsetDateTimeType(), () -> ((Condition)condition).getOnsetStringType()));
            return ctx.fuzzChild(condition, false, supplier);
        });
        return mutators;
    }
}

