/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Reference;

public class CompositionMutatorProvider
extends BaseDomainResourceMutatorProvider<Composition> {
    public CompositionMutatorProvider() {
        super(CompositionMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Composition>> createMutators() {
        LinkedList<FuzzingMutator<Composition>> mutators = new LinkedList<FuzzingMutator<Composition>>();
        mutators.add((ctx, composition) -> ctx.fuzzChild(composition, () -> ((Composition)composition).hasType(), () -> ((Composition)composition).getType()));
        mutators.add((ctx, composition) -> ctx.fuzzChildTypes(composition.getClass(), composition.getAuthor(), () -> ((Composition)composition).getAuthorFirstRep()));
        mutators.add((ctx, composition) -> ctx.fuzzChildTypes(composition.getClass(), composition.getCategory(), () -> ((Composition)composition).getCategoryFirstRep()));
        mutators.add((ctx, composition) -> ctx.randomness().chooseRandomly(composition.getSection()).map(sc -> {
            composition.getSection().remove(sc);
            return FuzzingLogEntry.operation(MessageFormat.format("Remove section for entry {0} from composition", sc));
        }).orElseGet(() -> FuzzingLogEntry.noop("do not remove any entries from composition")));
        mutators.add((ctx, composition) -> {
            Composition.SectionComponent section = new Composition.SectionComponent();
            Reference reference = section.addEntry().setReference(ctx.randomness().fhir().fhirResourceId());
            composition.getSection().add(section);
            FuzzingLogEntry entry = ctx.fuzzChild(composition.getClass(), reference);
            return FuzzingLogEntry.add(MessageFormat.format("Add random section to composition: {0}", reference.getReference()), entry);
        });
        return mutators;
    }
}

