/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.hl7.fhir.r4.model.CommunicationRequest;
import org.hl7.fhir.r4.model.Type;

public class CommunicationRequestMutatorProvider
extends BaseDomainResourceMutatorProvider<CommunicationRequest> {
    public CommunicationRequestMutatorProvider() {
        super(CommunicationRequestMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<CommunicationRequest>> createMutators() {
        LinkedList<FuzzingMutator<CommunicationRequest>> mutators = new LinkedList<FuzzingMutator<CommunicationRequest>>();
        mutators.add((ctx, comreq) -> ctx.fuzzChildTypes(comreq.getClass(), comreq.getBasedOn(), () -> ((CommunicationRequest)comreq).getBasedOnFirstRep()));
        mutators.add((ctx, comreq) -> ctx.fuzzChildTypes(comreq.getClass(), comreq.getAbout(), () -> ((CommunicationRequest)comreq).getAboutFirstRep()));
        mutators.add((ctx, comreq) -> ctx.fuzzChildTypes(comreq.getClass(), comreq.getIdentifier(), () -> ((CommunicationRequest)comreq).getIdentifierFirstRep()));
        mutators.add((ctx, comreq) -> ctx.fuzzChildTypes(comreq.getClass(), comreq.getMedium(), () -> ((CommunicationRequest)comreq).getMediumFirstRep()));
        mutators.add((ctx, comreq) -> ctx.fuzzChildTypes(comreq.getClass(), comreq.getReasonCode(), () -> ((CommunicationRequest)comreq).getReasonCodeFirstRep()));
        mutators.add((ctx, comreq) -> ctx.fuzzChildTypes(comreq.getClass(), comreq.getNote(), () -> ((CommunicationRequest)comreq).getNoteFirstRep()));
        mutators.add((ctx, comreq) -> ctx.fuzzChildTypes(comreq.getClass(), comreq.getReasonReference(), () -> ((CommunicationRequest)comreq).getReasonReferenceFirstRep()));
        mutators.add((ctx, comreq) -> ctx.fuzzChildTypes(comreq.getClass(), comreq.getRecipient(), () -> ((CommunicationRequest)comreq).getRecipientFirstRep()));
        mutators.add((ctx, comreq) -> ctx.fuzzChildTypes(comreq.getClass(), comreq.getCategory(), () -> ((CommunicationRequest)comreq).getCategoryFirstRep()));
        mutators.add((ctx, comreq) -> ctx.fuzzChild(comreq, () -> ((CommunicationRequest)comreq).hasEncounter(), () -> ((CommunicationRequest)comreq).getEncounter()));
        mutators.add((ctx, comreq) -> ctx.fuzzChild(comreq, () -> ((CommunicationRequest)comreq).hasRequester(), () -> ((CommunicationRequest)comreq).getRequester()));
        mutators.add((ctx, comreq) -> ctx.fuzzChild(comreq, () -> ((CommunicationRequest)comreq).hasDoNotPerform(), () -> ((CommunicationRequest)comreq).getDoNotPerformElement()));
        mutators.add((ctx, comreq) -> ctx.fuzzChild(comreq, () -> ((CommunicationRequest)comreq).hasGroupIdentifier(), () -> ((CommunicationRequest)comreq).getGroupIdentifier()));
        mutators.add((ctx, comreq) -> ctx.fuzzChild(comreq, () -> ((CommunicationRequest)comreq).hasSender(), () -> ((CommunicationRequest)comreq).getSender()));
        mutators.add((ctx, comreq) -> ctx.fuzzChild(comreq, () -> ((CommunicationRequest)comreq).hasAuthoredOn(), () -> ((CommunicationRequest)comreq).getAuthoredOnElement()));
        mutators.add((ctx, comreq) -> {
            if (comreq.hasOccurrence()) {
                return ctx.fuzzChild(comreq, () -> ((CommunicationRequest)comreq).hasOccurrencePeriod(), () -> ((CommunicationRequest)comreq).getOccurrence());
            }
            Supplier<Type> supplier = ctx.randomness().chooseRandomElement(List.of(() -> ((CommunicationRequest)comreq).getOccurrencePeriod(), () -> ((CommunicationRequest)comreq).getOccurrenceDateTimeType()));
            return ctx.fuzzChild(comreq, () -> ((CommunicationRequest)comreq).hasOccurrence(), supplier);
        });
        mutators.add((ctx, comreq) -> {
            List<Type> payloads = comreq.getPayload().stream().map(CommunicationRequest.CommunicationRequestPayloadComponent::getContent).toList();
            return ctx.fuzzChildTypes(comreq.getClass(), payloads);
        });
        mutators.add((ctx, comreq) -> {
            CommunicationRequest.CommunicationPriority priority = comreq.getPriority();
            CommunicationRequest.CommunicationPriority fpriority = ctx.randomness().chooseRandomFromEnum(CommunicationRequest.CommunicationPriority.class, priority);
            comreq.setPriority(fpriority);
            return FuzzingLogEntry.operation(MessageFormat.format("Change Priority of CommunicationRequest {0}: {1} -> {2}", comreq.getId(), priority, fpriority));
        });
        return mutators;
    }
}

